/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.debugger.GroovyHotSwapConfigurable;
import org.jetbrains.plugins.groovy.debugger.GroovySteppingConfigurableUi;

public final class GroovyDebuggerSettings
extends XDebuggerSettings<GroovyDebuggerSettings> {
    public Boolean DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS = true;
    public boolean ENABLE_GROOVY_HOTSWAP = true;

    public GroovyDebuggerSettings() {
        super("groovy_debugger");
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        return switch (category) {
            case DebuggerSettingsCategory.STEPPING -> Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.groovy", (String)GroovyBundle.message("groovy.debug.caption", new Object[0]), (String)"reference.idesettings.debugger.groovy", GroovySteppingConfigurableUi.class, () -> this));
            case DebuggerSettingsCategory.HOTSWAP -> Collections.singletonList(new GroovyHotSwapConfigurable(this));
            default -> Collections.emptyList();
        };
    }

    public GroovyDebuggerSettings getState() {
        return this;
    }

    public void loadState(@NotNull GroovyDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public static GroovyDebuggerSettings getInstance() {
        return (GroovyDebuggerSettings)GroovyDebuggerSettings.getInstance(GroovyDebuggerSettings.class);
    }
}

