/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public final class GroovyConsoleUtil {
    @NotNull
    @Nls
    public static String getDisplayGroovyVersion(@NotNull Module module) {
        String sdkVersion = GroovyConsoleUtilKt.sdkVersionIfHasNeededDependenciesToRunConsole(module);
        return sdkVersion == null ? GroovyBundle.message("groovy.version.bundled.0", BundledGroovy.getBundledGroovyVersion()) : GroovyBundle.message("groovy.version.0", sdkVersion);
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, GroovyConsoleUtilKt.getApplicableModules(project), (Function<Module, String>)((Function)GroovyConsoleUtil::getDisplayGroovyVersion), consumer);
    }

    @NotNull
    @Nls
    public static String getTitle(@NotNull Module module) {
        return GroovyBundle.message("module.name.0.and.groovy.version.1", module.getName(), GroovyConsoleUtil.getDisplayGroovyVersion(module));
    }
}

