/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;

public class GroovyConsoleResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        GroovyConsoleStateService projectConsole = GroovyConsoleStateService.getInstance(project);
        Module module = projectConsole.getSelectedModule(file);
        if (module == null || module.isDisposed()) {
            return null;
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        if (GroovyConsoleUtilKt.hasNeededDependenciesToRunConsole(module)) {
            return moduleScope;
        }
        GlobalSearchScope bundledScope = BundledGroovy.createBundledGroovyScope(project);
        return bundledScope != null ? moduleScope.uniteWith(bundledScope) : moduleScope;
    }
}

