/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

public class BuildAndRestartConsoleAction
extends AnAction {
    private final Module myModule;
    private final Project myProject;
    private final Executor myExecutor;
    private final RunContentDescriptor myContentDescriptor;
    private final Consumer<? super Module> myRestarter;

    public BuildAndRestartConsoleAction(@NotNull Module module, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor contentDescriptor, @NotNull Consumer<? super Module> restarter) {
        super(GroovyBundle.message("action.build.restart.text", new Object[0]), GroovyBundle.message("action.build.module.restart.description", module.getName()), AllIcons.Actions.Restart);
        this.myModule = module;
        this.myProject = project;
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myRestarter = restarter;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.myModule == null || this.myModule.isDisposed()) {
            return false;
        }
        ProcessHandler processHandler = this.myContentDescriptor.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (RunContentManager.getInstance((Project)this.myProject).removeRunContent(this.myExecutor, this.myContentDescriptor)) {
            CompilerManager.getInstance((Project)this.myProject).compile(this.myModule, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (!BuildAndRestartConsoleAction.this.myModule.isDisposed()) {
                        BuildAndRestartConsoleAction.this.myRestarter.consume((Object)BuildAndRestartConsoleAction.this.myModule);
                    }
                }
            });
        }
    }
}

