/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config.wizard;

import com.intellij.CommonBundle;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.distribution.DistributionComboBox;
import com.intellij.openapi.roots.ui.distribution.DistributionInfo;
import com.intellij.openapi.roots.ui.distribution.FileChooserInfo;
import com.intellij.openapi.roots.ui.distribution.LocalDistributionInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.RequestorsKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyDownloadableLibraryTypeKt;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.config.wizard.FrameworkLibraryDistributionInfo;
import org.jetbrains.plugins.groovy.config.wizard.GroovyProjectWizardUtils;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u001a\u001a\u0010\u0015\u001a\u00020\r*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060 \u001a\u0014\u0010!\u001a\u00020\r*\u00020\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0018\u0010#\u001a\u0004\u0018\u00010$*\u00020%2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0018\u0010&\u001a\u0004\u0018\u00010$*\u00020%2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"GROOVY_SDK_FALLBACK_VERSION", "", "MAIN_FILE", "MAIN_GROOVY_TEMPLATE", "getGroovySdkType", "sdk", "Lcom/intellij/openapi/roots/ui/distribution/DistributionInfo;", "getGroovySdkVersion", "isBlankDistribution", "", "distribution", "isInvalidSdk", "logGroovySdkChanged", "", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "moveUnstableVersionToTheEnd", "", "left", "Lcom/intellij/framework/library/FrameworkLibraryVersion;", "right", "createSampleGroovyCodeFile", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "sourceDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "groovySdkComboBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/openapi/roots/ui/distribution/DistributionComboBox;", "Lcom/intellij/ui/dsl/builder/Row;", "property", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "logGroovySdkFinished", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "validateGroovySdk", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "validateGroovySdkWithDialog", "intellij.groovy"})
@JvmName(name="GroovyProjectWizardUtils")
public final class GroovyProjectWizardUtils {
    @NotNull
    public static final String GROOVY_SDK_FALLBACK_VERSION = "3.0.9";
    @NotNull
    private static final String MAIN_FILE = "Main.groovy";
    @NotNull
    private static final String MAIN_GROOVY_TEMPLATE = "template.groovy";

    @NotNull
    public static final Cell<DistributionComboBox> groovySdkComboBox(@NotNull Row $this$groovySdkComboBox, @NotNull WizardContext context, @NotNull ObservableMutableProperty<DistributionInfo> property) {
        GroovyLibraryDescription groovyLibraryDescription = new GroovyLibraryDescription();
        DistributionComboBox comboBox2 = new DistributionComboBox(context.getProject(), new FileChooserInfo(groovyLibraryDescription){
            @NotNull
            private final String fileChooserTitle;
            @Nullable
            private final String fileChooserDescription;
            @NotNull
            private final FileChooserDescriptor fileChooserDescriptor;
            @NotNull
            private final Function1<Macro, Boolean> fileChooserMacroFilter;
            {
                this.fileChooserTitle = GroovyBundle.message("dialog.title.select.groovy.sdk", new Object[0]);
                this.fileChooserDescriptor = $groovyLibraryDescription.createFileChooserDescriptor();
                this.fileChooserMacroFilter = FileChooserInfo.Companion.getDIRECTORY_PATH();
            }

            @NotNull
            public String getFileChooserTitle() {
                return this.fileChooserTitle;
            }

            @Nullable
            public String getFileChooserDescription() {
                return this.fileChooserDescription;
            }

            @NotNull
            public FileChooserDescriptor getFileChooserDescriptor() {
                return this.fileChooserDescriptor;
            }

            @NotNull
            public Function1<Macro, Boolean> getFileChooserMacroFilter() {
                return this.fileChooserMacroFilter;
            }
        });
        comboBox2.setSpecifyLocationActionName(GroovyBundle.message("dialog.title.specify.groovy.sdk", new Object[0]));
        comboBox2.addLoadingItem();
        VirtualFile pathToGroovyHome = groovyLibraryDescription.findPathToGroovyHome();
        if (pathToGroovyHome != null) {
            comboBox2.addDistributionIfNotExists((DistributionInfo)new LocalDistributionInfo(pathToGroovyHome.getPath()));
        }
        GroovyDownloadableLibraryTypeKt.loadLatestGroovyVersions((DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>)((DownloadableFileSetVersions.FileSetVersionsCallback)new DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>(comboBox2){
            final /* synthetic */ DistributionComboBox $comboBox;
            {
                this.$comboBox = $comboBox;
            }

            public void onSuccess(@NotNull List<? extends FrameworkLibraryVersion> versions) {
                SwingUtilities.invokeLater(() -> groovySdkComboBox.1.onSuccess$lambda$1(versions, this.$comboBox));
            }

            public void onError(@NotNull String errorMessage) {
                this.$comboBox.removeLoadingItem();
            }

            private static final int onSuccess$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }

            /*
             * WARNING - void declaration
             */
            private static final void onSuccess$lambda$1(List $versions, DistributionComboBox $comboBox) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$versions, (arg_0, arg_1) -> groovySdkComboBox.1.onSuccess$lambda$1$lambda$0(groovySdkComboBox.onSuccess.1.1.INSTANCE, arg_0, arg_1));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    FrameworkLibraryVersion frameworkLibraryVersion = (FrameworkLibraryVersion)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new FrameworkLibraryDistributionInfo((FrameworkLibraryVersion)p0));
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    DistributionInfo p0 = (DistributionInfo)element$iv;
                    boolean bl = false;
                    $comboBox.addDistributionIfNotExists(p0);
                }
                $comboBox.removeLoadingItem();
            }
        }));
        return ComboBoxKt.whenItemSelectedFromUi$default((Cell)ComboBoxKt.columns((Cell)$this$groovySdkComboBox.cell((JComponent)comboBox2).applyToComponent((Function1)new Function1<DistributionComboBox, Unit>(property){
            final /* synthetic */ ObservableMutableProperty<DistributionInfo> $property;
            {
                this.$property = $property;
                super(1);
            }

            public final void invoke(@NotNull DistributionComboBox $this$applyToComponent) {
                $this$applyToComponent.bindSelectedDistribution(this.$property);
            }
        }).validationRequestor(RequestorsKt.getAFTER_PROPERTY_CHANGE().invoke(property)).validationOnInput((Function2)new Function2<ValidationInfoBuilder, DistributionComboBox, ValidationInfo>(property){
            final /* synthetic */ ObservableMutableProperty<DistributionInfo> $property;
            {
                this.$property = $property;
                super(2);
            }

            @Nullable
            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnInput, @NotNull DistributionComboBox it) {
                return GroovyProjectWizardUtils.access$validateGroovySdk($this$validationOnInput, (DistributionInfo)this.$property.get());
            }
        }).validationOnApply((Function2)new Function2<ValidationInfoBuilder, DistributionComboBox, ValidationInfo>(property){
            final /* synthetic */ ObservableMutableProperty<DistributionInfo> $property;
            {
                this.$property = $property;
                super(2);
            }

            @Nullable
            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull DistributionComboBox it) {
                return GroovyProjectWizardUtils.access$validateGroovySdkWithDialog($this$validationOnApply, (DistributionInfo)this.$property.get());
            }
        }), (int)25), null, (Function1)((Function1)new Function1<DistributionComboBox.Item, Unit>(context, property){
            final /* synthetic */ WizardContext $context;
            final /* synthetic */ ObservableMutableProperty<DistributionInfo> $property;
            {
                this.$context = $context;
                this.$property = $property;
                super(1);
            }

            public final void invoke(DistributionComboBox.Item it) {
                GroovyProjectWizardUtils.logGroovySdkChanged(this.$context, (DistributionInfo)this.$property.get());
            }
        }), (int)1, null);
    }

    private static final ValidationInfo validateGroovySdk(ValidationInfoBuilder $this$validateGroovySdk, DistributionInfo distribution) {
        if (GroovyProjectWizardUtils.isBlankDistribution(distribution)) {
            return $this$validateGroovySdk.error(GroovyBundle.message("dialog.title.validation.path.should.not.be.empty", new Object[0]));
        }
        if (GroovyProjectWizardUtils.isInvalidSdk(distribution)) {
            return $this$validateGroovySdk.error(GroovyBundle.message("dialog.title.validation.path.does.not.contain.groovy.sdk", new Object[0]));
        }
        return null;
    }

    private static final ValidationInfo validateGroovySdkWithDialog(ValidationInfoBuilder $this$validateGroovySdkWithDialog, DistributionInfo distribution) {
        String[] stringArray;
        if (GroovyProjectWizardUtils.isBlankDistribution(distribution)) {
            stringArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
            if (Messages.showDialog((String)GroovyBundle.message("dialog.title.no.jdk.specified.prompt", new Object[0]), (String)GroovyBundle.message("dialog.title.no.jdk.specified.title", new Object[0]), (String[])stringArray, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return $this$validateGroovySdkWithDialog.error(GroovyBundle.message("dialog.title.no.jdk.specified.error", new Object[0]));
            }
        }
        if (GroovyProjectWizardUtils.isInvalidSdk(distribution)) {
            stringArray = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
            if (Messages.showDialog((String)GroovyBundle.message("dialog.title.validation.directory.you.specified.does.not.contain.groovy.sdk.do.you.want.to.create.project.with.this.configuration", new Object[0]), (String)GroovyBundle.message("dialog.title.validation.invalid.sdk.specified.title", new Object[0]), (String[])stringArray, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return $this$validateGroovySdkWithDialog.error(GroovyBundle.message("dialog.title.validation.invalid.sdk.specified.error", new Object[0]));
            }
        }
        return null;
    }

    private static final boolean isBlankDistribution(DistributionInfo distribution) {
        return distribution == null || distribution instanceof LocalDistributionInfo && Intrinsics.areEqual((Object)((LocalDistributionInfo)distribution).getPath(), (Object)"");
    }

    private static final boolean isInvalidSdk(DistributionInfo distribution) {
        return distribution == null || distribution instanceof LocalDistributionInfo && GroovyConfigUtils.getInstance().getSDKVersionOrNull(((LocalDistributionInfo)distribution).getPath()) == null;
    }

    public static final void createSampleGroovyCodeFile(@NotNull ModuleBuilder $this$createSampleGroovyCodeFile, @NotNull Project project, @NotNull VirtualFile sourceDirectory) {
        WriteCommandAction.runWriteCommandAction((Project)project, (String)GroovyBundle.message("new.project.wizard.groovy.creating.main.file", new Object[0]), null, () -> GroovyProjectWizardUtils.createSampleGroovyCodeFile$lambda$0(project, sourceDirectory, $this$createSampleGroovyCodeFile), (PsiFile[])new PsiFile[0]);
    }

    public static final int moveUnstableVersionToTheEnd(@NotNull FrameworkLibraryVersion left, @NotNull FrameworkLibraryVersion right) {
        String leftVersion = left.getVersionString();
        String rightVersion = right.getVersionString();
        boolean leftUnstable = GroovyConfigUtils.isUnstable(leftVersion);
        boolean rightUnstable = GroovyConfigUtils.isUnstable(rightVersion);
        return leftUnstable == rightUnstable ? -GroovyConfigUtils.compareSdkVersions(leftVersion, rightVersion) : (leftUnstable ? 1 : -1);
    }

    public static final void logGroovySdkChanged(@NotNull WizardContext context, @Nullable DistributionInfo sdk) {
        String type2 = GroovyProjectWizardUtils.getGroovySdkType(sdk);
        String version = GroovyProjectWizardUtils.getGroovySdkVersion(sdk);
        NewProjectWizardCollector.Groovy.INSTANCE.logGroovyLibraryChanged(context, type2, version);
    }

    public static final void logGroovySdkFinished(@NotNull NewProjectWizardStep $this$logGroovySdkFinished, @Nullable DistributionInfo sdk) {
        String type2 = GroovyProjectWizardUtils.getGroovySdkType(sdk);
        String version = GroovyProjectWizardUtils.getGroovySdkVersion(sdk);
        NewProjectWizardCollector.Groovy.INSTANCE.logGroovyLibraryFinished($this$logGroovySdkFinished.getContext(), type2, version);
    }

    private static final String getGroovySdkType(DistributionInfo sdk) {
        String string;
        DistributionInfo distributionInfo = sdk;
        if (distributionInfo instanceof FrameworkLibraryDistributionInfo) {
            string = "maven";
        } else if (distributionInfo instanceof LocalDistributionInfo) {
            string = "local";
        } else if (distributionInfo == null) {
            string = null;
        } else {
            throw new IllegalStateException(("Unexpected distribution type: " + sdk).toString());
        }
        return string;
    }

    private static final String getGroovySdkVersion(DistributionInfo sdk) {
        String string;
        DistributionInfo distributionInfo = sdk;
        if (distributionInfo instanceof FrameworkLibraryDistributionInfo) {
            string = ((FrameworkLibraryDistributionInfo)sdk).getVersion().getVersionString();
        } else if (distributionInfo instanceof LocalDistributionInfo) {
            String string2;
            String it = string2 = GroovyConfigUtils.getInstance().getSDKVersion(((LocalDistributionInfo)sdk).getPath());
            boolean bl = false;
            string = !Intrinsics.areEqual((Object)it, (Object)"undefined") ? string2 : null;
        } else if (distributionInfo == null) {
            string = null;
        } else {
            throw new IllegalStateException(("Unexpected distribution type: " + sdk).toString());
        }
        return string;
    }

    private static final void createSampleGroovyCodeFile$lambda$0(Project $project, VirtualFile $sourceDirectory, ModuleBuilder $this_createSampleGroovyCodeFile) {
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)$project).getCodeTemplate(MAIN_GROOVY_TEMPLATE);
        VirtualFile helloWorldFile = $sourceDirectory.createChildData((Object)$this_createSampleGroovyCodeFile, MAIN_FILE);
        VfsUtil.saveText((VirtualFile)helloWorldFile, (String)fileTemplate.getText());
    }

    public static final /* synthetic */ ValidationInfo access$validateGroovySdk(ValidationInfoBuilder $receiver, DistributionInfo distribution) {
        return GroovyProjectWizardUtils.validateGroovySdk($receiver, distribution);
    }

    public static final /* synthetic */ ValidationInfo access$validateGroovySdkWithDialog(ValidationInfoBuilder $receiver, DistributionInfo distribution) {
        return GroovyProjectWizardUtils.validateGroovySdkWithDialog($receiver, distribution);
    }
}

