/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyDownloadableLibraryType;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GroovyLibraryDescription
extends CustomLibraryDescription {
    private static final String GROOVY_FRAMEWORK_NAME = "Groovy";
    private final String myEnvVariable;
    private final Set<? extends LibraryKind> myLibraryKinds;
    private final String myFrameworkName;
    private final DownloadableLibraryType myLibraryType;

    public GroovyLibraryDescription() {
        this("GROOVY_HOME", GroovyLibraryDescription.getAllGroovyKinds(), GROOVY_FRAMEWORK_NAME);
    }

    public static Set<? extends LibraryKind> getAllGroovyKinds() {
        HashSet<LibraryKind> kinds = new HashSet<LibraryKind>();
        for (LibraryPresentationProvider provider2 : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
            if (!(provider2 instanceof GroovyLibraryPresentationProviderBase)) continue;
            kinds.add(provider2.getKind());
        }
        return kinds;
    }

    public GroovyLibraryDescription(@NotNull String envVariable, @NotNull LibraryKind libraryKind, String frameworkName) {
        this(envVariable, Collections.singleton(libraryKind), frameworkName);
    }

    private GroovyLibraryDescription(@NotNull String envVariable, @NotNull Set<? extends LibraryKind> libraryKinds, String frameworkName) {
        this.myEnvVariable = envVariable;
        this.myLibraryKinds = libraryKinds;
        this.myFrameworkName = frameworkName;
        this.myLibraryType = (DownloadableLibraryType)LibraryType.EP_NAME.findExtension(GroovyDownloadableLibraryType.class);
    }

    @Nullable
    public static GroovyLibraryPresentationProviderBase findManager(@NotNull VirtualFile dir) {
        String name = dir.getName();
        List providers = ContainerUtil.findAll((Object[])((LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()), GroovyLibraryPresentationProviderBase.class);
        for (GroovyLibraryPresentationProviderBase provider2 : providers) {
            if (!provider2.managesName(name) || !provider2.isSDKHome(dir)) continue;
            return provider2;
        }
        for (GroovyLibraryPresentationProviderBase manager : providers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        return this.myLibraryKinds;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        VirtualFile initial = this.findPathToGroovyHome();
        FileChooserDescriptor descriptor = this.createFileChooserDescriptor();
        VirtualFile dir = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, null, (VirtualFile)initial);
        if (dir == null) {
            return null;
        }
        return this.createLibraryConfiguration(parentComponent, dir);
    }

    @Nullable
    public VirtualFile findPathToGroovyHome() {
        VirtualFile initial = GroovyLibraryDescription.findFile(System.getenv(this.myEnvVariable));
        if (initial == null && GROOVY_FRAMEWORK_NAME.equals(this.myFrameworkName)) {
            if (SystemInfo.isLinux) {
                return GroovyLibraryDescription.findFile("/usr/share/groovy");
            }
            if (SystemInfo.isMac) {
                return GroovyLibraryDescription.findFile("/usr/local/opt/groovy/libexec");
            }
        }
        return initial;
    }

    @NotNull
    public FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return GroovyLibraryDescription.findManager(file) != null;
            }
        };
        descriptor.setTitle(GroovyBundle.message("framework.0.sdk.chooser.title", this.myFrameworkName));
        descriptor.setDescription(GroovyBundle.message("framework.0.sdk.chooser.description", this.myFrameworkName));
        return descriptor;
    }

    @Nullable
    public NewLibraryConfiguration createLibraryConfiguration(@Nullable Component parentComponent, @NotNull VirtualFile pathToLibrary) {
        final GroovyLibraryPresentationProviderBase provider2 = GroovyLibraryDescription.findManager(pathToLibrary);
        if (provider2 == null) {
            return null;
        }
        final String path = pathToLibrary.getPath();
        String sdkVersion = provider2.getSDKVersion(path);
        if (sdkVersion == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)GroovyBundle.message("framework.0.sdk.chooser.error.message", this.myFrameworkName), (String)GroovyBundle.message("framework.0.sdk.chooser.error.title", new Object[0]));
            return null;
        }
        return new NewLibraryConfiguration(provider2.getLibraryPrefix() + "-" + sdkVersion){

            public void addRoots(@NotNull LibraryEditor editor) {
                provider2.fillLibrary(path, editor);
            }
        };
    }

    @Nullable
    private static VirtualFile findFile(String path) {
        if (path != null && !path.isEmpty()) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    @Nullable
    public DownloadableLibraryType getDownloadableLibraryType() {
        return this.myLibraryType;
    }
}

