/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtilsKt;
import org.jetbrains.plugins.groovy.config.GroovyHomeKind;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public final class GroovyConfigUtils
extends AbstractConfigUtils {
    @NonNls
    public static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-minimal)?(-(?<version>\\d+(\\.\\d+)*(-(?!indy)\\w+(-\\d+)?)?))?(-indy)?\\.jar");
    @NonNls
    public static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(?<version>\\d+(\\.\\d+)*(-(?!indy)\\w+(-\\d+)?)?))?(-indy)?\\.jar");
    @NlsSafe
    public static final String NO_VERSION = "<no version>";
    @NlsSafe
    public static final String GROOVY1_7 = "1.7";
    @NlsSafe
    public static final String GROOVY1_8 = "1.8";
    @NlsSafe
    public static final String GROOVY2_0 = "2.0";
    @NlsSafe
    public static final String GROOVY2_1 = "2.1";
    @NlsSafe
    public static final String GROOVY2_2 = "2.2";
    @NlsSafe
    public static final String GROOVY2_2_2 = "2.2.2";
    @NlsSafe
    public static final String GROOVY2_5_2 = "2.5.2";
    @NlsSafe
    public static final String GROOVY2_3 = "2.3";
    @NlsSafe
    public static final String GROOVY2_4 = "2.4";
    @NlsSafe
    public static final String GROOVY2_5 = "2.5";
    @NlsSafe
    public static final String GROOVY3_0 = "3.0";
    @NlsSafe
    public static final String GROOVY4_0 = "4.0";
    private static final GroovyConfigUtils ourGroovyConfigUtils = new GroovyConfigUtils();
    @NonNls
    private static final String LIB = "/lib";
    @NonNls
    private static final String EMBEDDABLE = "/embeddable";
    @NlsSafe
    private static final String ALPHA = "alpha";
    @NlsSafe
    private static final String BETA = "beta";
    @NlsSafe
    private static final String RC = "rc";
    @NlsSafe
    private static final String SNAPSHOT = "SNAPSHOT";

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        return ourGroovyConfigUtils;
    }

    public static File @NotNull [] getGroovyAllJars(@NotNull String path) {
        return LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_ALL_JAR_PATTERN);
    }

    public static boolean matchesGroovyAll(@NotNull String name) {
        return GROOVY_ALL_JAR_PATTERN.matcher(name).matches() && !name.contains("src") && !name.contains("doc");
    }

    public static boolean isAtLeastGroovy25(@NotNull PsiElement element) {
        return GroovyConfigUtils.getInstance().isVersionAtLeast(element, GROOVY2_5);
    }

    public static boolean isAtLeastGroovy40(@NotNull PsiElement element) {
        return GroovyConfigUtils.getInstance().isVersionAtLeast(element, GROOVY4_0);
    }

    @NlsSafe
    public static String getMavenSdkRepository(@NotNull String groovyVersion) {
        if (GroovyConfigUtils.compareSdkVersions(groovyVersion, GROOVY4_0) >= 0) {
            return "org.apache.groovy";
        }
        return "org.codehaus.groovy";
    }

    @Override
    @NlsSafe
    @Nullable
    public String getSDKVersionOrNull(@NlsSafe @NotNull String path) {
        String groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + LIB, GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + LIB, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + EMBEDDABLE, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        return groovyJarVersion;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    @NlsSafe
    public String getSDKVersion(@NotNull Module module) {
        return GroovyConfigUtilsKt.getSdkVersion(module);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version) {
        return this.isVersionAtLeast(psiElement, version, true);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version, boolean unknownResult) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return unknownResult;
        }
        String sdkVersion = this.getSDKVersion(module);
        if (sdkVersion == null) {
            return unknownResult;
        }
        return GroovyConfigUtils.compareSdkVersions(sdkVersion, version) >= 0;
    }

    public static int compareSdkVersions(@NotNull String leftVersion, @NotNull String rightVersion) {
        String[] leftVersionParts = leftVersion.split("[.-]");
        String[] rightVersionParts = rightVersion.split("[.-]");
        int sizes = Math.max(leftVersionParts.length, rightVersionParts.length);
        for (int i2 = 0; i2 < sizes; ++i2) {
            int rightNumber;
            int leftNumber = GroovyConfigUtils.getVersionPart(leftVersionParts, i2);
            if (leftNumber < (rightNumber = GroovyConfigUtils.getVersionPart(rightVersionParts, i2))) {
                return -1;
            }
            if (leftNumber <= rightNumber) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isUnstable(@NotNull String version) {
        return version.contains(ALPHA) || version.contains(BETA) || version.contains(RC);
    }

    private static int getVersionPart(String[] parts, int index) {
        String part;
        String string = part = index < parts.length ? parts[index] : "-4";
        if (part.equals(SNAPSHOT)) {
            return 999;
        }
        if (part.equals(ALPHA)) {
            return -3;
        }
        if (part.equals(BETA)) {
            return -2;
        }
        if (part.equals(RC)) {
            return -1;
        }
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException __) {
            return -4;
        }
    }

    @NotNull
    @NlsSafe
    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        return s != null ? s : NO_VERSION;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            String path = file.getPath();
            GroovyHomeKind kind = GroovyHomeKind.fromString(path);
            return kind != null;
        }
        return false;
    }

    @NotNull
    public String getSDKLibVersion(Library library) {
        return this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
    }

    public Collection<String> getSDKVersions(Library[] libraries) {
        return ContainerUtil.map2List((Object[])libraries, library -> this.getSDKLibVersion((Library)library));
    }
}

