/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovySdkForNewModuleWizardStep;
import org.jetbrains.plugins.groovy.config.wizard.GroovyProjectWizardUtils;

public final class GroovyAwareModuleBuilder
extends JavaModuleBuilder {
    @Nullable
    private String myPathToGroovySample = null;

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        return new GroovySdkForNewModuleWizardStep((ModuleBuilder)this, settingsStep);
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        if (this.myPathToGroovySample != null) {
            this.addGroovySample(rootModel);
        }
    }

    private void addGroovySample(@NotNull ModifiableRootModel rootModel) {
        Project project = rootModel.getProject();
        if (!project.isInitialized()) {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> this.doAddGroovySample(rootModel));
        } else {
            this.doAddGroovySample(rootModel);
        }
    }

    private void doAddGroovySample(@NotNull ModifiableRootModel rootModel) {
        String rootPath = this.getContentEntryPath();
        if (rootPath == null) {
            return;
        }
        VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)(rootPath + "/" + this.myPathToGroovySample)));
        if (root == null) {
            return;
        }
        GroovyProjectWizardUtils.createSampleGroovyCodeFile((ModuleBuilder)this, rootModel.getProject(), root);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @NonNls
    public String getBuilderId() {
        return "groovy";
    }

    public void addGroovySample(@NotNull String path) {
        this.myPathToGroovySample = path;
    }

    public Icon getNodeIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public String getDescription() {
        return GroovyBundle.message("module.with.groovy", new Object[0]);
    }

    public String getPresentableName() {
        return GroovyBundle.message("language.groovy", new Object[0]);
    }

    public String getGroupName() {
        return "Groovy";
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public int getWeight() {
        return 60;
    }
}

