/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.compiler.rt.GroovyRtJarPaths;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;

final class GrBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    private final Project myProject;

    GrBuildProcessParametersProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        File file;
        BackendCompiler backend;
        CompilerConfiguration config;
        CompilerConfiguration compilerConfiguration = config = this.myProject.isDefault() ? null : CompilerConfiguration.getInstance((Project)this.myProject);
        if (config instanceof CompilerConfigurationImpl && (backend = ((CompilerConfigurationImpl)config).getDefaultCompiler()) != null && backend.getId() == "Groovy-Eclipse" && (file = EclipseCompilerTool.findEcjJarFile()) != null) {
            return Collections.singletonList(file.getAbsolutePath());
        }
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<String> getAdditionalPluginPaths() {
        Path jarPath = PathManager.getJarForClass(GroovyBuilder.class);
        if (jarPath != null) {
            Supplier<List> roots = GrBuildProcessParametersProvider.lazy(() -> GroovyRtJarPaths.getGroovyRtRoots((File)jarPath.toFile(), (boolean)false));
            return () -> ((List)roots.get()).iterator();
        }
        return Collections.emptyList();
    }

    private static <T> Supplier<T> lazy(final Supplier<T> calculation) {
        return new Supplier<T>(){
            T cached = null;

            @Override
            public T get() {
                Object val = this.cached;
                if (val == null) {
                    this.cached = val = calculation.get();
                }
                return val;
            }
        };
    }
}

