/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unusedDef;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;

public final class UnusedDefInspection
extends GroovyLocalInspectionBase {
    private static final Logger LOG = Logger.getInstance(UnusedDefInspection.class);

    @NotNull
    public String getShortName() {
        return "GroovyUnusedAssignment";
    }

    @Override
    protected void check(@NotNull GrControlFlowOwner owner, final @NotNull ProblemsHolder problemsHolder) {
        ReachingDefinitionsSemilattice lattice;
        ReachingDefinitionsDfaInstance dfaInstance;
        Instruction[] flow = owner.getControlFlow();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance = new ReachingDefinitionsDfaInstance(), lattice = new ReachingDefinitionsSemilattice());
        List<DefinitionMap> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return;
        }
        IntOpenHashSet unusedDefs = new IntOpenHashSet();
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            unusedDefs.add(instruction.num());
        }
        for (int i2 = 0; i2 < dfaResult.size(); ++i2) {
            ReadWriteVariableInstruction varInst;
            Instruction instruction = flow[i2];
            if (!(instruction instanceof ReadWriteVariableInstruction) || (varInst = (ReadWriteVariableInstruction)instruction).isWrite()) continue;
            int descriptor = varInst.getDescriptor();
            DefinitionMap e = dfaResult.get(i2);
            if (e == null) continue;
            e.forEachValue(arg_0 -> UnusedDefInspection.lambda$check$1(flow, descriptor, (IntSet)unusedDefs, arg_0));
        }
        final HashSet checked = new HashSet();
        unusedDefs.forEach(num -> {
            ReadWriteVariableInstruction instruction = (ReadWriteVariableInstruction)flow[num];
            PsiElement element = instruction.getElement();
            UnusedDefInspection.process(element, checked, problemsHolder, GroovyBundle.message("unused.assignment.tooltip", new Object[0]));
        });
        owner.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof GrControlFlowOwner)) {
                    if (element instanceof GrVariable && !(element instanceof GrField)) {
                        GrVariable variable = (GrVariable)element;
                        if (checked.contains(variable) || variable.getInitializerGroovy() != null) {
                            return;
                        }
                        if (ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).findFirst() == null) {
                            UnusedDefInspection.process(variable, checked, problemsHolder, GroovyBundle.message("unused.variable", new Object[0]));
                        }
                    } else {
                        super.visitElement(element);
                    }
                }
            }
        });
    }

    private static void process(@Nullable PsiElement element, Set<PsiElement> checked, ProblemsHolder problemsHolder, @InspectionMessage String message) {
        if (element == null) {
            return;
        }
        if (!checked.add(element)) {
            return;
        }
        if (UnusedDefInspection.isLocalAssignment(element) && UnusedDefInspection.isUsedInTopLevelFlowOnly(element) && !UnusedDefInspection.isIncOrDec(element)) {
            PsiElement toHighlight = UnusedDefInspection.getHighlightElement(element);
            problemsHolder.registerProblem(toHighlight, message, new LocalQuickFix[0]);
        }
    }

    private static PsiElement getHighlightElement(PsiElement element) {
        PsiElement toHighlight = null;
        if (element instanceof GrReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrAssignmentExpression) {
                toHighlight = ((GrAssignmentExpression)parent2).getLValue();
            }
            if (parent2 instanceof GrUnaryExpression && ((GrUnaryExpression)parent2).isPostfix()) {
                toHighlight = parent2;
            }
        } else if (element instanceof GrVariable) {
            toHighlight = ((GrVariable)element).getNameIdentifierGroovy();
        }
        if (toHighlight == null) {
            toHighlight = element;
        }
        return toHighlight;
    }

    private static boolean isIncOrDec(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrUnaryExpression)) {
            return false;
        }
        IElementType type2 = ((GrUnaryExpression)parent2).getOperationTokenType();
        return type2 == GroovyTokenTypes.mINC || type2 == GroovyTokenTypes.mDEC;
    }

    private static boolean isUsedInTopLevelFlowOnly(PsiElement element) {
        PsiElement resolved;
        GrVariable var = null;
        if (element instanceof GrVariable) {
            var = (GrVariable)element;
        } else if (element instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)element).resolve()) instanceof GrVariable) {
            var = (GrVariable)resolved;
        }
        if (var != null) {
            GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(var);
            if (scope == null) {
                PsiFile file = var.getContainingFile();
                if (file == null) {
                    LOG.error("no file??? var of type" + var.getClass().getCanonicalName());
                } else {
                    TextRange range = var.getTextRange();
                    LOG.error("var: " + var.getName() + ", offset:" + (range != null ? range.getStartOffset() : -1) + ", owner: " + PsiTreeUtil.getParentOfType((PsiElement)var, GrControlFlowOwner.class));
                }
                return false;
            }
            return ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).forEach(ref2 -> ControlFlowUtils.findControlFlowOwner(ref2.getElement()) == scope);
        }
        return true;
    }

    private static boolean isLocalAssignment(PsiElement element) {
        if (element instanceof GrVariable) {
            return UnusedDefInspection.isLocalVariable((GrVariable)element, false);
        }
        if (element instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)element).resolve();
            return resolved instanceof GrVariable && UnusedDefInspection.isLocalVariable((GrVariable)resolved, true);
        }
        return false;
    }

    private static boolean isLocalVariable(GrVariable var, boolean parametersAllowed) {
        return !(var instanceof GrField) && (!(var instanceof GrParameter) || parametersAllowed);
    }

    private static /* synthetic */ void lambda$check$1(Instruction[] flow, int descriptor, IntSet unusedDefs, IntSet reaching) {
        reaching.forEach(defNum -> {
            int defDescriptor = ((ReadWriteVariableInstruction)flow[defNum]).getDescriptor();
            if (descriptor == defDescriptor) {
                unusedDefs.remove(defNum);
            }
        });
    }
}

