/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyUntypedAccessInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
                GrExpression qualifier;
                super.visitReferenceExpression(refExpr);
                if (PsiUtil.isThisOrSuperRef(refExpr)) {
                    return;
                }
                GroovyResolveResult resolveResult2 = refExpr.advancedResolve();
                PsiElement resolved = resolveResult2.getElement();
                if (resolved != null ? GrHighlightUtil.isDeclarationAssignment(refExpr) || resolved instanceof PsiPackage : (qualifier = refExpr.getQualifierExpression()) == null && GrHighlightUtil.isDeclarationAssignment(refExpr)) {
                    return;
                }
                PsiType refExprType = refExpr.getType();
                if (refExprType == null) {
                    if (resolved != null) {
                        this.registerError(refExpr);
                    }
                } else if (refExprType instanceof PsiClassType && ((PsiClassType)refExprType).resolve() == null) {
                    this.registerError(refExpr);
                }
            }
        };
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.cannot.determine.type.ref", new Object[0]);
    }
}

