/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"checkUnresolvedReference", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "highlightIfGroovyObjectOverridden", "", "highlightIfMissingMethodsDeclared", "highlightSink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "getBestResolveResults", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "results", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "intellij.groovy.psi"})
@JvmName(name="GroovyUnresolvedAccessChecker")
public final class GroovyUnresolvedAccessChecker {
    public static final void checkUnresolvedReference(@NotNull GrReferenceExpression expression, boolean highlightIfGroovyObjectOverridden, boolean highlightIfMissingMethodsDeclared, @NotNull HighlightSink highlightSink) {
        PsiElement psiElement = expression.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement referenceNameElement = psiElement;
        String string = expression.getReferenceName();
        if (string == null) {
            return;
        }
        String referenceName = string;
        PsiElement parent2 = expression.getParent();
        Collection<GroovyResolveResult> results = GroovyUnresolvedAccessChecker.getBestResolveResults(expression);
        if (!results.isEmpty()) {
            boolean staticsOk2;
            Object[] $this$all$iv;
            block13: {
                $this$all$iv = (Object[])results;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v2 = true;
                } else {
                    for (Object t : $this$all$iv) {
                        GroovyResolveResult p0 = (GroovyResolveResult)t;
                        boolean bl = false;
                        if (GrUnresolvedAccessChecker.isStaticOk(p0)) continue;
                        v2 = false;
                        break block13;
                    }
                    v2 = staticsOk2 = true;
                }
            }
            if (!staticsOk2) {
                $this$all$iv = new Object[]{referenceName};
                highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.reference.non.static", $this$all$iv), new LocalQuickFix[0]);
            }
            return;
        }
        if (ResolveUtil.isKeyOfMap(expression) || ResolveUtil.isClassReference(expression)) {
            return;
        }
        if (!highlightIfGroovyObjectOverridden && GrUnresolvedAccessChecker.areGroovyObjectMethodsOverridden(expression)) {
            return;
        }
        if (!highlightIfMissingMethodsDeclared && GrUnresolvedAccessChecker.areMissingMethodsDeclared(expression)) {
            return;
        }
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        if (parent2 instanceof GrMethodCall) {
            ((Collection)actions).add(GroovyQuickFixFactory.getInstance().createGroovyStaticImportMethodFix((GrMethodCall)parent2));
            if (PsiUtil.isNewified(expression)) {
                CollectionsKt.addAll((Collection)actions, (Iterable)ReferenceFixesKt.generateAddImportActions(expression));
            }
        } else {
            CollectionsKt.addAll((Collection)actions, (Iterable)ReferenceFixesKt.generateCreateClassActions(expression));
            CollectionsKt.addAll((Collection)actions, (Iterable)ReferenceFixesKt.generateAddImportActions(expression));
        }
        CollectionsKt.addAll((Collection)actions, (Iterable)ReferenceFixesKt.generateReferenceExpressionFixes(expression));
        QuickFixActionRegistrar registrar2 = new QuickFixActionRegistrar(actions){
            final /* synthetic */ ArrayList<IntentionAction> $actions;
            {
                this.$actions = $actions;
            }

            public void register(@NotNull IntentionAction action) {
                ((Collection)this.$actions).add(action);
            }

            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action, @Nullable HighlightDisplayKey key) {
                ((Collection)this.$actions).add(action);
            }
        };
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)expression), (QuickFixActionRegistrar)registrar2);
        QuickFixFactory.getInstance().registerOrderEntryFixes(registrar2, (PsiReference)expression);
        Object[] objectArray = new Object[]{referenceName};
        highlightSink.registerProblem(referenceNameElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, GroovyBundle.message("cannot.resolve", objectArray), (List<? extends IntentionAction>)actions);
    }

    private static final Collection<GroovyResolveResult> getBestResolveResults(GroovyReference ref2) {
        return GroovyUnresolvedAccessChecker.getBestResolveResults(ref2.resolve(false));
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<GroovyResolveResult> getBestResolveResults(Collection<? extends GroovyResolveResult> results) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = results;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            GroovyResolveResult p0 = (GroovyResolveResult)element$iv$iv;
            boolean bl = false;
            if (!p0.isStaticsOK()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection staticsOk2 = (List)destination$iv$iv;
        if (staticsOk2.isEmpty()) {
            return results;
        }
        Iterable $this$filter$iv2 = staticsOk2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroovyResolveResult p0 = (GroovyResolveResult)element$iv$iv;
            boolean bl = false;
            if (!p0.isAccessible()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection accessibleStaticsOk = (List)destination$iv$iv2;
        if (accessibleStaticsOk.isEmpty()) {
            return staticsOk2;
        }
        return accessibleStaticsOk;
    }
}

