/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ParameterCastFix;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.ApplicabilityResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ErasedArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0014J*\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00182\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0015J\b\u0010%\u001a\u00020&H\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0004J(\u0010,\u001a\u00020(2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020-0\u001c2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0014J(\u0010.\u001a\u00020&2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0002J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u00020&H\u0004J\b\u00101\u001a\u00020(H\u0014R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "getReference", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "getSink", "()Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "buildCastFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ExpressionArgument;", "expectedType", "Lcom/intellij/psi/PsiType;", "buildCastFixes", "", "results", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "result", "buildFixes", "getInapplicableMethodMessage", "containingType", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlightAmbiguousMethod", "", "highlightApplicable", "", "highlightCannotApplyError", "invokedText", "typesString", "highlightClosureInvocation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "highlightInapplicableMethod", "highlightMethodApplicability", "highlightUnknownArgs", "shouldHighlightInapplicable", "intellij.groovy.psi"})
public abstract class CallReferenceHighlighter {
    @NotNull
    private final GroovyCallReference reference;
    @NotNull
    private final HighlightSink sink;

    public CallReferenceHighlighter(@NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        this.reference = reference;
        this.sink = sink;
    }

    @NotNull
    protected final GroovyCallReference getReference() {
        return this.reference;
    }

    @NotNull
    protected final HighlightSink getSink() {
        return this.sink;
    }

    @NotNull
    protected String getAmbiguousMethodMessage() {
        return GroovyBundle.message("method.call.is.ambiguous", new Object[0]);
    }

    @Nls
    @NotNull
    protected String getInapplicableMethodMessage(@NotNull GroovyMethodResult result2, @NotNull PsiType containingType, @NotNull List<? extends Argument> arguments2) {
        String typeText = containingType.getInternalCanonicalText();
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        Object[] objectArray = new Object[]{result2.getElement().getName(), typeText, argumentsString2};
        return GroovyBundle.message("cannot.apply.method1", objectArray);
    }

    @NotNull
    protected abstract PsiElement getHighlightElement();

    protected final void highlightCannotApplyError(@NotNull String invokedText, @NotNull String typesString) {
        Object[] objectArray = new Object[]{invokedText, typesString};
        this.sink.registerError(this.getHighlightElement(), GroovyBundle.message("cannot.apply.method.or.closure", objectArray), new LocalQuickFix[0]);
    }

    protected final void highlightUnknownArgs() {
        this.sink.registerProblem(this.getHighlightElement(), ProblemHighlightType.WEAK_WARNING, GroovyBundle.message("cannot.infer.argument.types", new Object[0]), new LocalQuickFix[0]);
    }

    protected final void highlightAmbiguousMethod() {
        this.sink.registerError(this.getHighlightElement(), this.getAmbiguousMethodMessage(), new LocalQuickFix[0]);
    }

    private final void highlightInapplicableMethod(Collection<? extends GroovyMethodResult> results, List<? extends Argument> arguments2) {
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)CollectionsKt.firstOrNull((Iterable)results);
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        PsiMethod method = result2.getElement();
        PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
        String methodName = method.getName();
        PsiElement highlightElement = this.getHighlightElement();
        if (!highlightElement.isPhysical()) {
            return;
        }
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        if (containingClass == null) {
            this.highlightCannotApplyError(methodName, argumentsString2);
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiClassType containingType = factory.createType(containingClass, result2.getSubstitutor());
        LocalQuickFix[] fixes = (LocalQuickFix[])UtilKt.toArray((Collection)CollectionsKt.plus((Collection)this.buildCastFixes(results), (Iterable)this.buildFixes()), (Object[])LocalQuickFix.EMPTY_ARRAY);
        String message = this.getInapplicableMethodMessage(result2, (PsiType)containingType, arguments2);
        this.sink.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, Arrays.copyOf(fixes, fixes.length));
    }

    protected boolean shouldHighlightInapplicable() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean highlightMethodApplicability() {
        Iterable<ErasedArgument> iterable;
        void $this$mapTo$iv$iv;
        Object result2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            CallReferenceHighlighter $this$highlightMethodApplicability_u24lambda_u240 = this;
            boolean bl = false;
            $this$highlightMethodApplicability_u24lambda_u240.highlightUnknownArgs();
            return true;
        }
        List<Argument> userArguments = list;
        Collection<? extends GroovyResolveResult> results = this.reference.resolve(false);
        if (results.isEmpty()) {
            return false;
        }
        Iterable $this$highlightMethodApplicability_u24lambda_u240 = results;
        boolean $i$f$filterIsInstance = false;
        void var6_8 = $this$filterIsInstance$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GroovyMethodResult)) continue;
            collection.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)collection;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroovyMethodResult it = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            if (!(!it.isInvokedOnProperty())) continue;
            collection2.add(element$iv$iv);
        }
        List methodResults = (List)collection2;
        if (methodResults.isEmpty()) {
            return this.highlightClosureInvocation(results, userArguments);
        }
        Iterable $this$mapNotNull$iv = methodResults;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = iterable2;
        boolean $i$f$forEach2 = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair pair;
            Object t;
            Object element$iv$iv = t = bl.next();
            boolean bl2 = false;
            result2 = (GroovyMethodResult)element$iv$iv;
            boolean bl3 = false;
            Object object = result2.getCandidate();
            if (object != null && (object = object.getArgumentMapping()) != null) {
                Object mapping2 = object;
                boolean bl4 = false;
                pair = new Pair(result2, (Object)mapping2.highlightingApplicabilities(result2.getSubstitutor()));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resultApplicabilities = (List)destination$iv$iv;
        Iterable $this$map$iv = resultApplicabilities;
        boolean bl6 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl7 = false;
            iterable.add(((ApplicabilityResult)pair.getSecond()).getApplicability());
        }
        Applicability totalApplicability = Applicability.totalApplicability((List)destination$iv$iv2);
        switch (WhenMappings.$EnumSwitchMapping$0[totalApplicability.ordinal()]) {
            case 1: {
                void $this$mapNotNullTo$iv$iv;
                Iterable destination$iv$iv3;
                if (!this.shouldHighlightInapplicable()) {
                    return false;
                }
                GroovyMethodResult singleResult = (GroovyMethodResult)CollectionsKt.singleOrNull((List)methodResults);
                if (singleResult != null) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = userArguments;
                    boolean $i$f$map = false;
                    Iterable $i$f$forEach2 = $this$map$iv2;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean bl8 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void p0;
                        result2 = (Argument)item$iv$iv;
                        iterable = destination$iv$iv3;
                        boolean bl9 = false;
                        iterable.add(new ErasedArgument((Argument)p0));
                    }
                    if (GroovyApplicabilityProvider.checkProviders((List)destination$iv$iv3, singleResult.getElement()) == Applicability.applicable) {
                        return false;
                    }
                }
                Iterable $this$mapNotNull$iv2 = resultApplicabilities;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv3 = $this$mapNotNull$iv2;
                Collection collection3 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    GroovyMethodResult it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl10 = false;
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl11 = false;
                    GroovyMethodResult result3 = (GroovyMethodResult)pair.component1();
                    ApplicabilityResult applicabilityResult = (ApplicabilityResult)pair.component2();
                    if ((applicabilityResult.getApplicability() == Applicability.inapplicable ? result3 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl12 = false;
                    collection3.add(it$iv$iv);
                }
                Collection inapplicableResults = (List)collection3;
                this.highlightInapplicableMethod(inapplicableResults, userArguments);
                return true;
            }
            case 2: {
                if (methodResults.size() != 1) {
                    Argument it;
                    Iterable $this$any$iv = userArguments;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator3 = $this$any$iv.iterator();
                    do {
                        if (!iterator3.hasNext()) return false;
                        Object element$iv = iterator3.next();
                        it = (Argument)element$iv;
                        boolean bl13 = false;
                    } while (!(it.getType() == null));
                    boolean bl14 = true;
                    if (!bl14) return false;
                }
                this.highlightUnknownArgs();
                return true;
            }
            case 3: {
                if (resultApplicabilities.size() <= 1) return this.highlightApplicable((GroovyMethodResult)((Pair)CollectionsKt.single((List)resultApplicabilities)).getFirst());
                this.highlightAmbiguousMethod();
                return true;
            }
        }
        return false;
    }

    protected boolean highlightClosureInvocation(@NotNull Collection<? extends GroovyResolveResult> results, @NotNull List<? extends Argument> arguments2) {
        return false;
    }

    protected boolean highlightApplicable(@NotNull GroovyMethodResult result2) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(Collection<? extends GroovyMethodResult> results) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = results;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GroovyMethodResult p0 = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.buildCastFixes(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(GroovyMethodResult result2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterTo$iv$iv;
        GroovyMethodCandidate groovyMethodCandidate = result2.getCandidate();
        if (groovyMethodCandidate == null) {
            return CollectionsKt.emptyList();
        }
        GroovyMethodCandidate candidate = groovyMethodCandidate;
        ArgumentMapping<PsiCallParameter> argumentMapping2 = candidate.getArgumentMapping();
        if (argumentMapping2 == null) {
            return CollectionsKt.emptyList();
        }
        ArgumentMapping<PsiCallParameter> mapping2 = argumentMapping2;
        ArgumentMapping<PsiCallParameter> argumentMapping3 = candidate.getArgumentMapping();
        if (argumentMapping3 == null || (argumentMapping3 = argumentMapping3.highlightingApplicabilities(result2.getSubstitutor())) == null) {
            return CollectionsKt.emptyList();
        }
        ArgumentMapping<PsiCallParameter> applicabilities = argumentMapping3;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> $this$filter$iv = applicabilities.getArgumentApplicabilities();
        boolean $i$f$filter = false;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            Map.Entry entry = element$iv$iv;
            boolean bl = false;
            ApplicabilityResult.ArgumentApplicability data = (ApplicabilityResult.ArgumentApplicability)entry.getValue();
            if (!(data.getApplicability() == Applicability.inapplicable)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set notApplicableArguments = destination$iv$iv.keySet();
        PsiElement callElement = this.reference.getElement();
        PsiSubstitutor substitutor2 = GroovyInferenceSessionBuilderKt.buildTopLevelSession$default(callElement, false, SetsKt.setOf((Object)new Function1<GrExpression, Boolean>(notApplicableArguments){
            final /* synthetic */ Set<Argument> $notApplicableArguments;
            {
                this.$notApplicableArguments = $notApplicableArguments;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GrExpression it) {
                return !this.$notApplicableArguments.contains(new ExpressionArgument(it));
            }
        }), false, 8, null).inferSubst();
        Iterable $this$filterIsInstance$iv = notApplicableArguments;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$filterTo22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExpressionArgument)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LocalQuickFix it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ExpressionArgument argument = (ExpressionArgument)element$iv$iv;
            boolean bl2 = false;
            PsiType fixType = substitutor2.substitute(mapping2.expectedType(argument));
            if ((fixType != null ? this.buildCastFix(argument, fixType) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Nullable
    protected LocalQuickFix buildCastFix(@NotNull ExpressionArgument argument, @NotNull PsiType expectedType) {
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        int position = arguments2.indexOf(argument);
        if (position < 0) {
            return null;
        }
        return new ParameterCastFix(argument.getExpression(), position, expectedType);
    }

    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.inapplicable.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.canBeApplicable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.applicable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

