/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"commonNegate", "", "num", "extractLiteralValue", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isPossibleLooseOfPrecision", "", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "intellij.groovy.psi"})
@JvmName(name="PrecisionUtil")
public final class PrecisionUtil {
    public static final boolean isPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrExpression expression) {
        int targetRank = TypeConstants.getTypeRank(targetType);
        int actualRank = TypeConstants.getTypeRank(actualType);
        if (targetRank == 2 || actualRank == 2 || targetRank == 7) {
            return false;
        }
        if (actualRank == 0 || targetRank == 0 || actualRank <= targetRank) {
            return false;
        }
        Number number = PrecisionUtil.extractLiteralValue(expression);
        if (number == null) {
            return true;
        }
        Number value2 = number;
        return switch (targetRank) {
            case 1 -> {
                byte byteVal = value2.byteValue();
                Number var7_11 = value2;
                if (var7_11 instanceof Short) {
                    if (!((short)byteVal == value2.shortValue())) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Integer) {
                    if (!Intrinsics.areEqual((Object)byteVal, (Object)value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)byteVal, (Object)value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Float) {
                    if (!((Object)Float.valueOf(byteVal)).equals(value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)byteVal, (Object)value2)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                short shortVal = value2.shortValue();
                Number var7_12 = value2;
                if (var7_12 instanceof Integer) {
                    if (!Intrinsics.areEqual((Object)shortVal, (Object)value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_12 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)shortVal, (Object)value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_12 instanceof Float) {
                    if (!((Object)Float.valueOf(shortVal)).equals(value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)shortVal, (Object)value2)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                int intVal = value2.intValue();
                Number var7_13 = value2;
                if (var7_13 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)intVal, (Object)value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_13 instanceof Float) {
                    if (!((Object)Float.valueOf(intVal)).equals(value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)intVal, (Object)value2)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                long longVal = value2.longValue();
                if (value2 instanceof Float) {
                    if (!((Object)Float.valueOf(longVal)).equals(value2)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)longVal, (Object)value2)) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                float floatVal = value2.floatValue();
                if (!Intrinsics.areEqual((Object)floatVal, (Object)value2)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final Number extractLiteralValue(GrExpression expression) {
        GrExpression grExpression;
        IElementType operationTokenType;
        Object[] objectArray;
        boolean negativeNumber = false;
        GrExpression valueExpression = expression;
        if (expression instanceof GrUnaryExpression && ArraysKt.contains((Object[])(objectArray = new IElementType[]{GroovyElementTypes.T_PLUS, GroovyElementTypes.T_MINUS}), (Object)(operationTokenType = ((GrUnaryExpression)expression).getOperationTokenType()))) {
            negativeNumber = Intrinsics.areEqual((Object)operationTokenType, (Object)GroovyElementTypes.T_MINUS);
            valueExpression = ((GrUnaryExpression)expression).getOperand();
        }
        GrLiteral grLiteral = (grExpression = valueExpression) instanceof GrLiteral ? (GrLiteral)grExpression : null;
        Object object = grLiteral != null ? grLiteral.getValue() : null;
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        Number value2 = number;
        return negativeNumber ? (Number)PrecisionUtil.commonNegate(value2) : (Number)value2;
    }

    private static final Number commonNegate(Number num) {
        Number number;
        Number number2 = num;
        if (number2 instanceof Byte) {
            number = (int)(-num.byteValue());
        } else if (number2 instanceof Short) {
            number = (int)(-num.shortValue());
        } else if (number2 instanceof Integer) {
            number = -num.intValue();
        } else if (number2 instanceof Long) {
            number = -num.longValue();
        } else if (number2 instanceof BigInteger) {
            BigInteger bigInteger = ((BigInteger)num).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
            number = bigInteger;
        } else if (number2 instanceof Float) {
            number = Float.valueOf(-num.floatValue());
        } else if (number2 instanceof Double) {
            number = -num.doubleValue();
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)num).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.negate()");
            number = bigDecimal;
        } else {
            number = null;
        }
        return number;
    }
}

