/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.typing.TuplesKt;

public abstract class GroovyStaticTypeCheckVisitorBase
extends GroovyTypeCheckVisitor {
    @Override
    public final void visitElement(@NotNull GroovyPsiElement element) {
    }

    @Override
    protected abstract void registerError(@NotNull PsiElement var1, @InspectionMessage @NotNull String var2, LocalQuickFix @Nullable [] var3, @NotNull ProblemHighlightType var4);

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer != null) {
            this.checkTupleAssignment(initializer, expression.getLValue().getExpressions().length);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GrExpression initializer;
        if (variableDeclaration.isTuple() && (initializer = variableDeclaration.getTupleInitializer()) != null) {
            this.checkTupleAssignment(initializer, variableDeclaration.getVariables().length);
        }
        super.visitVariableDeclaration(variableDeclaration);
    }

    private void checkTupleAssignment(@NotNull GrExpression initializer, int leftCount) {
        Integer componentCount = TuplesKt.getMultiAssignmentTypesCountCS(initializer);
        if (componentCount == null) {
            this.registerError((PsiElement)initializer, GroovyBundle.message("multiple.assignments.without.list.expr", new Object[0]), new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createMultipleAssignmentFix(leftCount)}, ProblemHighlightType.GENERIC_ERROR);
        } else if (componentCount < leftCount) {
            this.registerError((PsiElement)initializer, GroovyBundle.message("incorrect.number.of.values", leftCount, componentCount), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR);
        }
    }

    @Override
    public void visitSpreadArgument(@NotNull GrSpreadArgument spreadArgument) {
        this.registerError((PsiElement)spreadArgument, GroovyBundle.message("spread.operator.is.not.available", new Object[0]), GroovyStaticTypeCheckVisitorBase.buildSpreadArgumentFix(spreadArgument), ProblemHighlightType.GENERIC_ERROR);
    }

    private static LocalQuickFix[] buildSpreadArgumentFix(GrSpreadArgument spreadArgument) {
        GrCallExpression parent2 = (GrCallExpression)PsiTreeUtil.getParentOfType((PsiElement)spreadArgument, GrCallExpression.class);
        if (parent2 == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiMethod resolveMethod = parent2.resolveMethod();
        if (resolveMethod == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createSpreadArgumentFix(resolveMethod.getParameters().length)};
    }
}

