/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringTransformationFixFactoryKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StringKind;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"FIXES", "", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyFix;", "createStringTransformationFix", "targetKind", "getCurrentKind", "quote", "", "getQuoteByKind", "kind", "getStringTransformationFix", "intellij.groovy.psi"})
public final class GrStringTransformationFixFactoryKt {
    @NotNull
    private static final Map<StringKind, GroovyFix> FIXES;

    @NotNull
    public static final GroovyFix getStringTransformationFix(@NotNull StringKind targetKind) {
        GroovyFix groovyFix = FIXES.get((Object)targetKind);
        Intrinsics.checkNotNull((Object)groovyFix);
        return groovyFix;
    }

    private static final StringKind getCurrentKind(String quote) {
        return switch (quote) {
            case "$/" -> StringKind.DOLLAR_SLASHY;
            case "/" -> StringKind.SLASHY;
            case "\"" -> StringKind.DOUBLE_QUOTED;
            case "'''" -> StringKind.TRIPLE_SINGLE_QUOTED;
            case "\"\"\"" -> StringKind.TRIPLE_DOUBLE_QUOTED;
            case "'" -> StringKind.SINGLE_QUOTED;
            default -> null;
        };
    }

    private static final String getQuoteByKind(StringKind kind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1 -> "'";
            case 2 -> "'''";
            case 3 -> "\"";
            case 4 -> "\"\"\"";
            case 5 -> "/";
            case 6 -> "$/";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final GroovyFix createStringTransformationFix(StringKind targetKind) {
        return new GroovyFix(targetKind){
            final /* synthetic */ StringKind $targetKind;
            {
                this.$targetKind = $targetKind;
            }

            @NotNull
            public String getFamilyName() {
                return GroovyBundle.message("intention.family.name.fix.quotation", new Object[0]);
            }

            @NotNull
            public String getName() {
                return switch (createStringTransformationFix.WhenMappings.$EnumSwitchMapping$0[this.$targetKind.ordinal()]) {
                    case 1 -> GroovyBundle.message("intention.name.convert.to.single.quoted.string", new Object[0]);
                    case 2 -> GroovyBundle.message("intention.name.change.quotes.to.triple.single.quotes", new Object[0]);
                    case 3 -> GroovyBundle.message("intention.name.convert.to.double.quoted.string", new Object[0]);
                    case 4 -> GroovyBundle.message("intention.name.change.quotes.to.triple.double.quotes", new Object[0]);
                    case 5 -> GroovyBundle.message("intention.name.convert.to.slashy.string", new Object[0]);
                    case 6 -> GroovyBundle.message("intention.name.convert.to.dollar.slashy.string", new Object[0]);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            private final String escapeTextPart(StringKind innerKind, String text) {
                return this.$targetKind.escape(innerKind.unescape(text));
            }

            private final String getNewText(GrLiteral literal) {
                String literalText = literal.getText();
                String quote = GrStringUtil.getStartQuote(literalText);
                StringKind stringKind = GrStringTransformationFixFactoryKt.access$getCurrentKind(quote);
                if (stringKind == null) {
                    return literalText;
                }
                StringKind kind = stringKind;
                return literal instanceof GrString ? ArraysKt.joinToString$default((Object[])((GrString)literal).getAllContentParts(), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<GroovyPsiElement, CharSequence>(this, kind){
                    final /* synthetic */ createStringTransformationFix.1 this$0;
                    final /* synthetic */ StringKind $kind;
                    {
                        this.this$0 = $receiver;
                        this.$kind = $kind;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(GroovyPsiElement it) {
                        return it instanceof GrStringContent ? (CharSequence)createStringTransformationFix.1.access$escapeTextPart(this.this$0, this.$kind, ((GrStringContent)it).getText()) : (CharSequence)it.getText();
                    }
                }), (int)30, null) : this.escapeTextPart(kind, GrStringUtil.removeQuotes(literalText));
            }

            /*
             * WARNING - void declaration
             */
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                void $this$parentOfType$iv;
                PsiElement psiElement = descriptor.getPsiElement();
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                GrLiteral grLiteral = (GrLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrLiteral.class, (boolean)false);
                if (grLiteral == null) {
                    return;
                }
                GrLiteral literal = grLiteral;
                String newText = this.getNewText(literal);
                String newQuote = GrStringTransformationFixFactoryKt.access$getQuoteByKind(this.$targetKind);
                String endQuote = Intrinsics.areEqual((Object)newQuote, (Object)"$/") ? "/$" : newQuote;
                GrExpression newExpression = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(newQuote + newText + endQuote);
                literal.replaceWithExpression(newExpression, true);
            }

            public static final /* synthetic */ String access$escapeTextPart(createStringTransformationFix.1 $this, StringKind innerKind, String text) {
                return $this.escapeTextPart(innerKind, text);
            }
        };
    }

    public static final /* synthetic */ StringKind access$getCurrentKind(String quote) {
        return GrStringTransformationFixFactoryKt.getCurrentKind(quote);
    }

    public static final /* synthetic */ String access$getQuoteByKind(StringKind kind) {
        return GrStringTransformationFixFactoryKt.getQuoteByKind(kind);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        StringKind[] $this$map$iv = StringKind.values();
        boolean $i$f$map = false;
        StringKind[] stringKindArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)GrStringTransformationFixFactoryKt.createStringTransformationFix((StringKind)it)));
        }
        FIXES = MapsKt.toMap((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StringKind.values().length];
            try {
                nArray[StringKind.SINGLE_QUOTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringKind.TRIPLE_SINGLE_QUOTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringKind.DOUBLE_QUOTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringKind.TRIPLE_DOUBLE_QUOTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringKind.SLASHY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringKind.DOLLAR_SLASHY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

