/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00012\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a.\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"QUOTE_TO_KIND", "", "", "Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "countScores", "", "text", "findBestQuotationForEscaping", "Lkotlin/Pair;", "literalText", "fallbackKindForEscapedStrings", "mainStringKind", "intellij.groovy.psi"})
public final class EscapingKt {
    @NotNull
    private static final Map<String, GrStringStyleViolationInspection.InspectionStringQuotationKind> QUOTE_TO_KIND;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Pair<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> findBestQuotationForEscaping(@NotNull String literalText, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind fallbackKindForEscapedStrings, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind mainStringKind) {
        Map.Entry bestEscaping2;
        String startQuote = GrStringUtil.getStartQuote(literalText);
        String unescapedText = GrStringUtil.unescapeString(GrStringUtil.removeQuotes(literalText));
        GrStringStyleViolationInspection.InspectionStringQuotationKind inspectionStringQuotationKind = QUOTE_TO_KIND.get(startQuote);
        if (inspectionStringQuotationKind == null) {
            return null;
        }
        GrStringStyleViolationInspection.InspectionStringQuotationKind currentQuotation = inspectionStringQuotationKind;
        Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> scores = EscapingKt.countScores(unescapedText);
        Integer n = scores.get((Object)currentQuotation);
        if (n == null) return null;
        int currentScore = n;
        Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> map2 = scores;
        Object object = (arg_0, arg_1) -> EscapingKt.findBestQuotationForEscaping$lambda$0((Function2)new Function2<Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, ? extends Integer>, Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, ? extends Integer>, Integer>(mainStringKind, currentQuotation, fallbackKindForEscapedStrings){
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $mainStringKind;
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $currentQuotation;
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $fallbackKindForEscapedStrings;
            {
                this.$mainStringKind = $mainStringKind;
                this.$currentQuotation = $currentQuotation;
                this.$fallbackKindForEscapedStrings = $fallbackKindForEscapedStrings;
                super(2);
            }

            @NotNull
            public final Integer invoke(Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> entry, Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> entry2) {
                GrStringStyleViolationInspection.InspectionStringQuotationKind leftKind = entry.getKey();
                int leftScore = ((Number)entry.getValue()).intValue();
                GrStringStyleViolationInspection.InspectionStringQuotationKind rightKind = entry2.getKey();
                int rightScore = ((Number)entry2.getValue()).intValue();
                return leftScore == rightScore ? (leftKind == this.$mainStringKind ? -1 : (rightKind == this.$mainStringKind ? 1 : (leftKind == this.$currentQuotation ? -1 : (rightKind == this.$currentQuotation ? 1 : (leftKind == this.$fallbackKindForEscapedStrings ? -1 : (rightKind == this.$fallbackKindForEscapedStrings ? 1 : leftKind.toString().compareTo(rightKind.toString()))))))) : Intrinsics.compare((int)leftScore, (int)rightScore);
            }
        }, arg_0, arg_1);
        Map.Entry entry = bestEscaping2 = (Map.Entry)CollectionsKt.minWithOrNull((Iterable)map2.entrySet(), (Comparator)object);
        Map.Entry entry2 = entry;
        if (entry == null) return null;
        Object it = entry2;
        boolean bl = false;
        Pair pair = TuplesKt.to(it.getKey(), (Object)(currentScore - ((Number)it.getValue()).intValue()));
        entry2 = pair;
        if (pair == null) return null;
        it = object = entry2;
        boolean bl2 = false;
        if (((Number)it.getSecond()).intValue() < 0) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Object object2 = object;
        return object2;
    }

    private static final Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> countScores(String text) {
        int doubleQuotes = 0;
        int singleQuotes = 0;
        int dollars = 0;
        int doubleQuoteSequence = 0;
        int tripleQuotes = 0;
        int tripleDoubleQuotes = 0;
        int singleQuoteSequence = 0;
        int slashes = 0;
        int reversedSlashes = 0;
        int n = text.length();
        for (int j = 0; j < n; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                ++doubleQuotes;
                ++doubleQuoteSequence;
            } else {
                tripleDoubleQuotes += doubleQuoteSequence / 3;
                doubleQuoteSequence = 0;
            }
            if (c == '\'') {
                ++singleQuotes;
                ++singleQuoteSequence;
            } else {
                tripleQuotes += singleQuoteSequence / 3;
                singleQuoteSequence = 0;
            }
            char c2 = c;
            if (c2 == '$') {
                ++dollars;
                continue;
            }
            if (c2 == '/') {
                ++slashes;
                continue;
            }
            if (c2 != '\\') continue;
            ++reversedSlashes;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED), (Object)(doubleQuotes + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED), (Object)(singleQuotes + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED), (Object)(tripleQuotes * 3 + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED), (Object)(tripleDoubleQuotes * 3 + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED), (Object)dollars), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY), (Object)slashes)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final int findBestQuotationForEscaping$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"'", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED)), TuplesKt.to((Object)"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED)), TuplesKt.to((Object)"'''", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED)), TuplesKt.to((Object)"\"\"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED)), TuplesKt.to((Object)"/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY)), TuplesKt.to((Object)"$/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED))};
        QUOTE_TO_KIND = MapsKt.toMap((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

