/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.spellchecker;

import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.spellchecker.GrDocCommentTokenizer;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovySpellcheckingStrategy
extends SpellcheckingStrategy {
    private final GrDocCommentTokenizer myDocCommentTokenizer = new GrDocCommentTokenizer();
    private final Tokenizer<PsiElement> myStringTokenizer = new EscapeSequenceTokenizer<PsiElement>(){

        public void tokenize(@NotNull PsiElement literal, TokenConsumer consumer) {
            String text = GrStringUtil.removeQuotes(literal.getText());
            if (!text.contains("\\")) {
                consumer.consumeToken(literal, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder();
                int[] offsets = new int[text.length() + 1];
                GrStringUtil.parseStringCharacters(text, unescapedText, offsets);
                1.processTextWithOffsets((PsiElement)literal, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)GrStringUtil.getStartQuote(literal.getText()).length());
            }
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement name;
        if (TokenSets.STRING_LITERAL_SET.contains(element.getNode().getElementType())) {
            return this.myStringTokenizer;
        }
        if (element instanceof GrNamedElement && TokenSets.STRING_LITERAL_SET.contains((name = ((GrNamedElement)element).getNameIdentifierGroovy()).getNode().getElementType())) {
            return EMPTY_TOKENIZER;
        }
        if (element instanceof PsiDocComment) {
            return this.myDocCommentTokenizer;
        }
        return super.getTokenizer(element);
    }
}

