/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.secondUnsafeCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.inspections.SecondUnsafeCallQuickFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SecondUnsafeCallInspection
extends GroovyLocalInspectionTool {
    @Override
    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression refExpression) {
                SecondUnsafeCallInspection.checkForSecondUnsafeCall(refExpression, holder);
            }
        };
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder) {
        SecondUnsafeCallInspection.checkForSecondUnsafeCall(expression, holder, null);
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder, @Nullable PsiElement highlightElement) {
        GrReferenceExpression referenceExpression;
        if (highlightElement == null) {
            highlightElement = expression;
        }
        if (GroovyTokenTypes.mDOT.equals((referenceExpression = (GrReferenceExpression)expression).getDotTokenType()) && SecondUnsafeCallInspection.isNullableQualifier(referenceExpression.getQualifierExpression())) {
            holder.registerProblem(highlightElement, GroovyBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
        }
    }

    private static boolean isNullableQualifier(GrExpression qualifier) {
        GrExpression newQualifier = qualifier;
        while (newQualifier != null) {
            GrReferenceExpression innerRefExpr = SecondUnsafeCallInspection.getReferenceExpression(newQualifier);
            if (innerRefExpr == null) {
                return false;
            }
            IElementType dotToken = innerRefExpr.getDotTokenType();
            if (GroovyTokenTypes.mOPTIONAL_CHAIN_DOT.equals(dotToken)) {
                return false;
            }
            newQualifier = (GrExpression)innerRefExpr.getQualifier();
        }
        GrReferenceExpression topRefExpr = SecondUnsafeCallInspection.getReferenceExpression(qualifier);
        if (topRefExpr == null) {
            return false;
        }
        return GroovyTokenTypes.mOPTIONAL_DOT.equals(topRefExpr.getDotTokenType());
    }

    @Nullable
    private static GrReferenceExpression getReferenceExpression(GrExpression expression) {
        if (expression instanceof GrMethodCallExpression) {
            expression = ((GrMethodCallExpression)expression).getInvokedExpression();
        }
        return expression instanceof GrReferenceExpression ? (GrReferenceExpression)expression : null;
    }
}

