/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class GroovyStaticVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return GroovyBundle.message("inspection.message.static.variable.name.ref.too.short", new Object[0]);
        }
        if (className.length() > this.getMaxLength()) {
            return GroovyBundle.message("inspection.message.static.variable.name.ref.too.long", new Object[0]);
        }
        return GroovyBundle.message("inspection.message.static.variable.name.ref.doesnt.match.regex", this.getRegex());
    }

    @Override
    protected String getDefaultRegex() {
        return "s_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(@NotNull GrField grField) {
            super.visitField(grField);
            if (!grField.hasModifierProperty("static")) {
                return;
            }
            if (grField.hasModifierProperty("final")) {
                return;
            }
            String name = grField.getName();
            if (GroovyStaticVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grField, name);
        }
    }
}

