/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.CyclomaticComplexityVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyComplexMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyOverlyComplexMethodInspectionBase() {
        super(10);
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.method.ref.overly.complex.cyclomatic.complexity", args[0], args[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            super.visitMethod(grMethod);
            int limit = GroovyOverlyComplexMethodInspectionBase.this.getLimit();
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor2);
            int complexity = visitor2.getComplexity();
            if (complexity <= limit) {
                return;
            }
            this.registerMethodError(grMethod, complexity, limit);
        }
    }
}

