/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class RemoveUnusedGrParameterFix
implements IntentionAction {
    private final String myName;

    public RemoveUnusedGrParameterFix(GrParameter parameter) {
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        return GroovyBundle.message("remove.parameter.0", this.myName);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("remove.unused.parameter", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)at, GrParameter.class);
        return parameter != null && this.myName.equals(parameter.getName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GrParameter parameter = RemoveUnusedGrParameterFix.getParameter(editor, file);
        if (parameter == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parameter.getContainingFile())) {
            return;
        }
        GrMethod method = (GrMethod)parameter.getDeclarationScope();
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(parameter.getProject(), RemoveUnusedGrParameterFix.createChangeInfo(method, parameter));
        processor.run();
    }

    @Nullable
    private static GrParameter getParameter(Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)at, GrParameter.class);
        if (parameter == null) {
            return null;
        }
        return parameter;
    }

    private static GrChangeInfoImpl createChangeInfo(GrMethod method, GrParameter parameter) {
        ArrayList<GrParameterInfo> params = new ArrayList<GrParameterInfo>();
        int i2 = 0;
        for (GrParameter p : method.getParameterList().getParameters()) {
            if (p != parameter) {
                params.add(new GrParameterInfo(p, i2));
            }
            ++i2;
        }
        GrTypeElement typeElement = method.getReturnTypeElementGroovy();
        CanonicalTypes.Type wrapper = typeElement != null ? CanonicalTypes.createTypeWrapper((PsiType)method.getReturnType()) : null;
        return new GrChangeInfoImpl(method, null, wrapper, method.getName(), params, null, false);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        GrParameter parameter = RemoveUnusedGrParameterFix.getParameter(editor, file);
        if (parameter == null) {
            return IntentionPreviewInfo.EMPTY;
        }
        parameter.delete();
        return IntentionPreviewInfo.DIFF;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

