/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.gpath;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyListGetCanBeKeyedAccessInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.call.to.ref.can.be.keyed.access", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new ReplaceWithPropertyAccessFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            super.visitMethodCallExpression(grMethodCallExpression);
            GrArgumentList args = grMethodCallExpression.getArgumentList();
            if (args.getExpressionArguments().length != 1) {
                return;
            }
            if (PsiImplUtil.hasNamedArguments(args)) {
                return;
            }
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            String name = referenceExpression.getReferenceName();
            if (!"get".equals(name)) {
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                return;
            }
            if (GroovyTokenSets.SAFE_DOTS.contains(referenceExpression.getDotTokenType())) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List")) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }

    private static class ReplaceWithPropertyAccessFix
    extends GroovyFix {
        private ReplaceWithPropertyAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            return GroovyBundle.message("intention.family.name.replace.with.keyed.access", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement referenceName = descriptor.getPsiElement();
            GrReferenceExpression invokedExpression = (GrReferenceExpression)referenceName.getParent();
            GrMethodCallExpression callExpression = (GrMethodCallExpression)invokedExpression.getParent();
            GrArgumentList args = callExpression.getArgumentList();
            GrExpression arg = args.getExpressionArguments()[0];
            ReplaceWithPropertyAccessFix.replaceExpression(callExpression, invokedExpression.getQualifierExpression().getText() + "[" + arg.getText() + "]");
        }
    }
}

