/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveElementQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    private final String myName;
    @FileModifier.SafeFieldForPreview
    private final Function<? super PsiElement, ? extends PsiElement> myElementFunction;

    public RemoveElementQuickFix(@IntentionFamilyName @NotNull String name) {
        this(name, (Function<? super PsiElement, ? extends PsiElement>)Functions.identity());
    }

    public RemoveElementQuickFix(@IntentionFamilyName @NotNull String name, @NotNull Function<? super PsiElement, ? extends PsiElement> function) {
        this.myName = name;
        this.myElementFunction = function;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.myName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement descriptorElement = descriptor.getPsiElement();
        if (descriptorElement == null) {
            return;
        }
        PsiElement elementToRemove = (PsiElement)this.myElementFunction.fun((Object)descriptorElement);
        if (elementToRemove == null) {
            return;
        }
        elementToRemove.delete();
    }
}

