/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public final class InvalidWriteAccessSearcher {
    @Nullable
    public static List<ReadWriteVariableInstruction> findInvalidWriteAccess(@NotNull GroovyControlFlow flow, @NotNull Set<? extends GrVariable> variables, @NotNull Set<? extends GrVariable> alreadyInitialized) {
        DFAEngine<MyData> engine = new DFAEngine<MyData>(flow.getFlow(), new MyDFAInstance(), new MySemilattice());
        List<@Nullable MyData> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return null;
        }
        ArrayList<ReadWriteVariableInstruction> result2 = new ArrayList<ReadWriteVariableInstruction>();
        Set descriptors = variables.stream().filter(Objects::nonNull).map($this$createDescriptor -> flow.getIndex(VariableDescriptorFactory.createDescriptor($this$createDescriptor))).collect(Collectors.toSet());
        Set initializedDescriptors = alreadyInitialized.stream().filter(Objects::nonNull).map($this$createDescriptor -> flow.getIndex(VariableDescriptorFactory.createDescriptor($this$createDescriptor))).collect(Collectors.toSet());
        for (int i2 = 0; i2 < flow.getFlow().length; ++i2) {
            Instruction instruction = flow.getFlow()[i2];
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            MyData initialized = dfaResult.get(i2);
            int descriptor = ((ReadWriteVariableInstruction)instruction).getDescriptor();
            if (!descriptors.contains(descriptor)) continue;
            if (initializedDescriptors.contains(descriptor)) {
                if (!initialized.isInitialized(descriptor)) continue;
                result2.add((ReadWriteVariableInstruction)instruction);
                continue;
            }
            if (!initialized.isOverInitialized(descriptor)) continue;
            result2.add((ReadWriteVariableInstruction)instruction);
        }
        return result2;
    }

    private static class MyDFAInstance
    implements DfaInstance<MyData> {
        private MyDFAInstance() {
        }

        @Override
        public MyData fun(@NotNull MyData e, @NotNull Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite()) {
                return e.add(((ReadWriteVariableInstruction)instruction).getDescriptor());
            }
            return e;
        }
    }

    private static class MySemilattice
    implements Semilattice<MyData> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public MyData join(@NotNull List<? extends MyData> ins) {
            return new MyData(ins);
        }
    }

    private static class MyData {
        private final @Unmodifiable Set<Integer> myInitialized;
        private final @Unmodifiable Set<Integer> myOverInitialized;

        MyData(List<? extends MyData> ins) {
            this(new HashSet<Integer>(), new HashSet<Integer>());
            for (MyData myData : ins) {
                this.myInitialized.addAll(myData.myInitialized);
                this.myOverInitialized.addAll(myData.myOverInitialized);
            }
        }

        MyData() {
            this(Set.of(), Set.of());
        }

        MyData(Set<Integer> initialized, Set<Integer> overInitialized) {
            this.myInitialized = initialized;
            this.myOverInitialized = overInitialized;
        }

        public MyData add(Integer var) {
            if (this.myInitialized.contains(var)) {
                Set<Integer> newOverInitialized;
                if (this.myOverInitialized.contains(var)) {
                    newOverInitialized = this.myOverInitialized;
                } else {
                    newOverInitialized = new HashSet<Integer>(this.myOverInitialized);
                    newOverInitialized.add(var);
                }
                return new MyData(this.myInitialized, newOverInitialized);
            }
            HashSet<Integer> newInitialized = new HashSet<Integer>(this.myInitialized);
            newInitialized.add(var);
            return new MyData(newInitialized, this.myOverInitialized);
        }

        public boolean equals(Object obj) {
            return obj instanceof MyData && this.myInitialized.equals(((MyData)obj).myInitialized) && this.myOverInitialized.equals(((MyData)obj).myOverInitialized);
        }

        public boolean isOverInitialized(int var) {
            return this.myOverInitialized.contains(var);
        }

        public boolean isInitialized(int var) {
            return this.myInitialized.contains(var);
        }
    }
}

