/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class UnnecessaryQualifiedReferenceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                super.visitCodeReferenceElement(refElement);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(refElement)) {
                    this.registerError(refElement);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(referenceExpression) || UnnecessaryQualifiedReferenceInspection.isQualifiedStaticMethodWithUnnecessaryQualifier(referenceExpression)) {
                    this.registerError(referenceExpression);
                }
            }
        };
    }

    private static boolean isQualifiedStaticMethodWithUnnecessaryQualifier(GrReferenceExpression ref2) {
        PsiElement copyResolved;
        PsiClass container;
        if (ref2.getQualifier() == null) {
            return false;
        }
        if (ref2.hasAt()) {
            return false;
        }
        PsiElement resolved = ref2.resolve();
        if (!(resolved instanceof PsiMember)) {
            return false;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return false;
        }
        if (GroovyConfigUtils.isAtLeastGroovy40(ref2) && (container = ((PsiMember)resolved).getContainingClass()) != null && container.isInterface()) {
            return false;
        }
        PsiElement parent2 = ref2.getParent();
        if (parent2 instanceof GrMethodCall) {
            GrMethodCall copy = (GrMethodCall)parent2.copy();
            GrReferenceExpression invoked = (GrReferenceExpression)copy.getInvokedExpression();
            assert (invoked != null);
            invoked.setQualifier(null);
            copyResolved = ((GrReferenceExpression)copy.getInvokedExpression()).resolve();
        } else {
            GrReferenceExpression copy = (GrReferenceExpression)ref2.copy();
            copy.setQualifier(null);
            copyResolved = copy.resolve();
        }
        return ref2.getManager().areElementsEquivalent(copyResolved, resolved);
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.display.name.unnecessary.qualified.reference", new Object[0]);
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return GroovyQuickFixFactory.getInstance().createReplaceWithImportFix();
    }

    private static boolean canBeSimplified(PsiElement element) {
        GrReferenceElement ref2;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class) != null) {
            return false;
        }
        if (element instanceof GrCodeReferenceElement) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrImportStatement.class, GrPackageDefinition.class}) != null) {
                return false;
            }
        } else if (element instanceof GrReferenceExpression) {
            if (!PsiImplUtil.seemsToBeQualifiedClassName((GrReferenceExpression)element)) {
                return false;
            }
        } else {
            return false;
        }
        if ((ref2 = (GrReferenceElement)element).getQualifier() == null) {
            return false;
        }
        if (!(ref2.getContainingFile() instanceof GroovyFileBase)) {
            return false;
        }
        PsiElement resolved = ref2.resolve();
        if (!(resolved instanceof PsiClass)) {
            return false;
        }
        String name = ((PsiClass)resolved).getName();
        if (name == null) {
            return false;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrReferenceExpression shortedRef = factory.createReferenceExpressionFromText(name, element);
        GroovyResolveResult resolveResult2 = shortedRef.advancedResolve();
        if (element.getManager().areElementsEquivalent(resolved, resolveResult2.getElement())) {
            return true;
        }
        PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
        if (containingClass != null && !GroovyCodeStyleSettingsFacade.getInstance(containingClass.getProject()).insertInnerClassImports()) {
            return false;
        }
        return resolveResult2.getElement() == null || !resolveResult2.isAccessible() || !resolveResult2.isStaticsOK();
    }
}

