/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GroovyPointlessBooleanInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("pointless.boolean.problem.descriptor", new Object[0]);
    }

    @Nullable
    private static String calculateSimplifiedBinaryExpression(GrBinaryExpression expression) {
        IElementType sign = expression.getOperationTokenType();
        GrExpression lhs = expression.getLeftOperand();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return null;
        }
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        if (sign.equals(GroovyElementTypes.T_LAND)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyElementTypes.T_LOR)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyElementTypes.T_XOR) || sign.equals(GroovyElementTypes.T_NEQ)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        if (sign.equals(GroovyElementTypes.T_EQ)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(GrExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)exp;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        String baseText = exp.getText();
        if (ParenthesesUtils.getPrecedence(exp) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + baseText + ")";
        }
        return "!" + baseText;
    }

    @NonNls
    private static String calculateSimplifiedPrefixExpression(GrUnaryExpression expression) {
        GrExpression operand = expression.getOperand();
        if (GroovyPointlessBooleanInspection.isUnaryNot(operand)) {
            return GroovyPointlessBooleanInspection.booleanLiteral(((GrUnaryExpression)operand).getOperand());
        }
        return GroovyPointlessBooleanInspection.negateBooleanLiteral(operand);
    }

    @NotNull
    private static String negateBooleanLiteral(GrExpression operand) {
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "false";
        }
        if (GroovyPointlessBooleanInspection.isFalse(operand)) {
            return "true";
        }
        throw new IllegalStateException(operand.getText());
    }

    @NotNull
    private static String booleanLiteral(GrExpression operand) {
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "true";
        }
        if (GroovyPointlessBooleanInspection.isFalse(operand)) {
            return "false";
        }
        throw new IllegalStateException(operand.getText());
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new BooleanLiteralComparisonFix();
    }

    private static boolean isPointless(IElementType sign, GrExpression rhs, GrExpression lhs) {
        if (sign.equals(GroovyElementTypes.T_EQ) || sign.equals(GroovyElementTypes.T_NEQ)) {
            return GroovyPointlessBooleanInspection.equalityExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_LAND)) {
            return GroovyPointlessBooleanInspection.andExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_LOR)) {
            return GroovyPointlessBooleanInspection.orExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_XOR)) {
            return GroovyPointlessBooleanInspection.xorExpressionIsPointless(lhs, rhs);
        }
        return false;
    }

    private static boolean equalityExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return (GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isFalse(lhs)) && GroovyPointlessBooleanInspection.isBoolean(rhs) || (GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(rhs)) && GroovyPointlessBooleanInspection.isBoolean(lhs);
    }

    private static boolean isBoolean(GrExpression expression) {
        PsiType type2 = expression.getType();
        return PsiType.BOOLEAN.equals((Object)type2);
    }

    private static boolean andExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs);
    }

    private static boolean orExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean xorExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean isUnaryNot(GrExpression arg) {
        return arg instanceof GrUnaryExpression && ((GrUnaryExpression)arg).getOperationTokenType() == GroovyElementTypes.T_NOT;
    }

    private static boolean isBooleanLiteral(GrExpression arg) {
        return GroovyPointlessBooleanInspection.isFalse(arg) || GroovyPointlessBooleanInspection.isTrue(arg);
    }

    private static boolean isTrue(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        @NonNls String text = expression.getText();
        return "true".equals(text);
    }

    private static boolean isFalse(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        @NonNls String text = expression.getText();
        return "false".equals(text);
    }

    private static class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private static final TokenSet booleanTokens = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.T_LAND, GroovyElementTypes.T_LOR, GroovyElementTypes.T_XOR, GroovyElementTypes.T_EQ, GroovyElementTypes.T_NEQ});

        private PointlessBooleanExpressionVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (PsiUtilKt.isFake(expression)) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!booleanTokens.contains(sign)) {
                return;
            }
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            if (GroovyPointlessBooleanInspection.isPointless(sign, rhs, lhs)) {
                this.registerError(expression);
            }
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            IElementType sign = expression.getOperationTokenType();
            if (!sign.equals(GroovyElementTypes.T_NOT)) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (GroovyPointlessBooleanInspection.isBooleanLiteral(operand)) {
                PsiElement parent2 = expression.getParent();
                if (parent2 instanceof GrExpression && GroovyPointlessBooleanInspection.isUnaryNot((GrExpression)parent2)) {
                    return;
                }
                this.registerError(expression);
            } else if (GroovyPointlessBooleanInspection.isUnaryNot(operand) && GroovyPointlessBooleanInspection.isBooleanLiteral(((GrUnaryExpression)operand).getOperand())) {
                this.registerError(expression);
            }
        }
    }

    private static class BooleanLiteralComparisonFix
    extends GroovyFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            return GroovyBundle.message("pointless.boolean.quickfix", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof GrBinaryExpression) {
                GrBinaryExpression expression = (GrBinaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            } else {
                GrUnaryExpression expression = (GrUnaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            }
        }
    }
}

