/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyOverlyComplexArithmeticExpressionInspectionBase
extends BaseInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    private int getLimit() {
        return this.m_limit;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.overly.complex.arithmetic.expression", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);

        private Visitor() {
            this.arithmeticTokens.add(GroovyTokenTypes.mPLUS);
            this.arithmeticTokens.add(GroovyTokenTypes.mMINUS);
            this.arithmeticTokens.add(GroovyTokenTypes.mSTAR);
            this.arithmeticTokens.add(GroovyTokenTypes.mDIV);
            this.arithmeticTokens.add(GroovyTokenTypes.mMOD);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(GrExpression expression) {
            if (this.isParentArithmetic(expression)) {
                return;
            }
            if (!this.isArithmetic(expression)) {
                return;
            }
            if (this.containsStringConcatenation(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= GroovyOverlyComplexArithmeticExpressionInspectionBase.this.getLimit()) {
                return;
            }
            this.registerError(expression);
        }

        private int countTerms(GrExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isArithmetic(expression)) {
                return 1;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                GrExpression operand = unaryExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(GrExpression expression) {
            PsiElement parent2 = expression.getParent();
            if (!(parent2 instanceof GrExpression)) {
                return false;
            }
            return this.isArithmetic((GrExpression)parent2);
        }

        private boolean isArithmetic(GrExpression expression) {
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationTokenType();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                IElementType sign = unaryExpression.getOperationTokenType();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.isArithmetic(contents);
            }
            return false;
        }

        private boolean containsStringConcatenation(GrExpression expression) {
            if (this.isString(expression)) {
                return true;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                if (this.containsStringConcatenation(lhs)) {
                    return true;
                }
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.containsStringConcatenation(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                GrExpression operand = unaryExpression.getOperand();
                return this.containsStringConcatenation(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.containsStringConcatenation(contents);
            }
            return false;
        }

        private boolean isString(GrExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type2 = expression.getType();
            if (type2 == null) {
                return false;
            }
            return type2.equalsToText("java.lang.String");
        }
    }
}

