/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

public class GroovyNegatedIfInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.negated.if.condition.expression", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement grIfStatement) {
            super.visitIfStatement(grIfStatement);
            GrExpression condition = grIfStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (!BoolUtils.isNegation(condition)) {
                return;
            }
            if (grIfStatement.getElseBranch() == null || grIfStatement.getThenBranch() == null) {
                return;
            }
            this.registerError(condition);
        }
    }
}

