/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class GroovyGStringKeyInspection
extends BaseInspection {
    @NlsSafe
    private static final String PUT_METHOD = "put";

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.gstring.used.as.maps.key", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument namedArgument) {
            PsiElement parent2 = namedArgument.getParent();
            if (!(parent2 instanceof GrListOrMap) || !((GrListOrMap)parent2).isMap()) {
                return;
            }
            GrArgumentLabel argumentLabel = namedArgument.getLabel();
            if (argumentLabel == null) {
                return;
            }
            GrExpression labelExpression = argumentLabel.getExpression();
            if (labelExpression == null) {
                return;
            }
            if (Visitor.isGStringType(labelExpression)) {
                this.registerError(argumentLabel);
            }
        }

        @Override
        public void visitExpression(@NotNull GrExpression grExpression) {
            PsiElement gstringParent = grExpression.getParent();
            if (!(gstringParent instanceof GrArgumentList)) {
                return;
            }
            GrExpression[] arguments2 = ((GrArgumentList)gstringParent).getExpressionArguments();
            if (arguments2.length != 2 || !arguments2[0].equals(grExpression)) {
                return;
            }
            PsiElement grandparent = gstringParent.getParent();
            if (!(grandparent instanceof GrMethodCall)) {
                return;
            }
            if (!Visitor.isGStringType(grExpression)) {
                return;
            }
            if (!this.isMapPutMethod((GrMethodCall)grandparent)) {
                return;
            }
            this.registerError(grExpression);
        }

        boolean isMapPutMethod(@NotNull GrMethodCall grMethodCall) {
            PsiMethod[] methods;
            PsiMethod method = grMethodCall.resolveMethod();
            if (method == null) {
                return false;
            }
            if (!GroovyGStringKeyInspection.PUT_METHOD.equals(method.getName())) {
                return false;
            }
            PsiClass mapClass = JavaPsiFacade.getInstance((Project)grMethodCall.getProject()).findClass("java.util.Map", grMethodCall.getResolveScope());
            if (mapClass == null) {
                return false;
            }
            for (PsiMethod superMethod : methods = mapClass.findMethodsByName(GroovyGStringKeyInspection.PUT_METHOD, false)) {
                if (!superMethod.equals(method) && !PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)superMethod)) continue;
                return true;
            }
            return false;
        }

        private static boolean isGStringType(@NotNull GrExpression expression) {
            PsiType expressionType = expression.getType();
            return expressionType != null && expressionType.equalsToText("groovy.lang.GString");
        }
    }
}

