/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return GroovyBundle.message("inspection.message.double.negation.ref", new Object[0]);
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return new DoubleNegationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    private static class DoubleNegationFix
    extends GroovyFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return GroovyBundle.message("intention.family.name.remove.double.negation", new Object[0]);
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrUnaryExpression expression = (GrUnaryExpression)descriptor.getPsiElement();
            GrExpression operand = (GrExpression)PsiUtil.skipParentheses(expression.getOperand(), false);
            if (operand instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)operand;
                GrExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                DoubleNegationFix.replaceExpression(expression, innerOperand.getText());
            } else if (operand instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)operand;
                GrExpression lhs = binaryExpression.getLeftOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                GrExpression rhs = binaryExpression.getRightOperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                DoubleNegationFix.replaceExpression(expression, builder.toString());
            }
        }
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyElementTypes.T_NOT.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyElementTypes.T_NEQ.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        private void checkParent(GrExpression expression) {
            PsiElement parent2 = expression.getParent();
            while (parent2 instanceof GrParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof GrUnaryExpression)) {
                return;
            }
            GrUnaryExpression prefixExpression = (GrUnaryExpression)parent2;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!GroovyElementTypes.T_NOT.equals(parentTokenType)) {
                return;
            }
            this.registerError(prefixExpression);
        }
    }
}

