/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrDeprecatedAPIUsageInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref2) {
                super.visitReferenceExpression(ref2);
                PsiElement resolveResult2 = this.getResolveElement(ref2);
                this.checkRef(resolveResult2, ref2.getReferenceNameElement(), ref2.getReferenceName());
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement ref2) {
                super.visitCodeReferenceElement(ref2);
                PsiElement resolveResult2 = this.getResolveElement(ref2);
                this.checkRef(resolveResult2, ref2.getReferenceNameElement(), ref2.getReferenceName());
            }

            @Override
            public void visitArgumentLabel(@NotNull GrArgumentLabel argumentLabel) {
                super.visitArgumentLabel(argumentLabel);
                PsiElement resolveResult2 = this.getResolveElement(argumentLabel);
                if (resolveResult2 instanceof GrAccessorMethod) {
                    resolveResult2 = ((GrAccessorMethod)resolveResult2).getProperty();
                }
                this.checkRef(resolveResult2, argumentLabel.getNameElement(), argumentLabel.getName());
            }

            @Override
            public void visitNewExpression(@NotNull GrNewExpression ref2) {
                super.visitNewExpression(ref2);
                PsiMethod resolvedCall = ref2.resolveMethod();
                if (resolvedCall == null || this.isDeprecated((PsiElement)resolvedCall.getContainingClass())) {
                    return;
                }
                GrCodeReferenceElement referenceElement = ref2.getReferenceElement();
                if (referenceElement != null) {
                    this.checkRef((PsiElement)resolvedCall, ref2.getReferenceElement(), referenceElement.getReferenceName());
                } else {
                    this.checkRef((PsiElement)resolvedCall, ref2, resolvedCall.getName());
                }
            }

            private void checkRef(PsiElement resolved, PsiElement elementToHighlight, String elementName) {
                if (this.isDeprecated(resolved)) {
                    this.registerError(elementToHighlight, GroovyBundle.message("0.is.deprecated", elementName), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }

            @Nullable
            private PsiElement getResolveElement(GroovyReference reference) {
                GroovyResolveResult[] results;
                for (GroovyResolveResult result2 : results = reference.multiResolve(false)) {
                    PsiElement element = result2.getElement();
                    if (element == null) continue;
                    return element;
                }
                return null;
            }

            private boolean isDeprecated(PsiElement resolved) {
                if (resolved instanceof PsiDocCommentOwner) {
                    return ((PsiDocCommentOwner)resolved).isDeprecated();
                }
                return resolved instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)resolved));
            }
        };
    }
}

