/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class AddMethodFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(AddMethodFix.class);
    private final String myMethodName;
    private final String myClassName;
    private final SmartPsiElementPointer<GrTypeDefinition> myPsiClassPointer;

    public AddMethodFix(@NotNull String methodName, @NotNull GrTypeDefinition aClass) {
        this.myMethodName = methodName;
        this.myClassName = aClass.getName();
        this.myPsiClassPointer = PointersKt.createSmartPointer((PsiElement)aClass);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrTypeDefinition definition = (GrTypeDefinition)this.myPsiClassPointer.getElement();
        if (definition == null) {
            return null;
        }
        GrTypeDefinition copy = (GrTypeDefinition)PsiTreeUtil.findSameElementInCopy((PsiElement)definition, (PsiFile)target);
        return new AddMethodFix(this.myMethodName, copy);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrTypeDefinition psiClass = (GrTypeDefinition)this.myPsiClassPointer.getElement();
        if (psiClass == null) {
            return;
        }
        if (psiClass.isInterface()) {
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("def " + psiClass.getName() + " " + this.myMethodName + "();");
            psiClass.add(method);
        } else {
            String templName = "Implemented Method Body.java";
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templName);
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            String returnType2 = AddMethodFix.generateTypeText(psiClass);
            properties.setProperty("RETURN_TYPE", returnType2);
            properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType((PsiClass)psiClass)));
            properties.setProperty("CALL_SUPER", "");
            properties.setProperty("CLASS_NAME", psiClass.getQualifiedName());
            properties.setProperty("SIMPLE_CLASS_NAME", psiClass.getName());
            properties.setProperty("METHOD_NAME", this.myMethodName);
            try {
                String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
                GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
                GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("", this.myMethodName, returnType2, ArrayUtilRt.EMPTY_STRING_ARRAY, psiClass);
                method.setBlock(newBody);
                psiClass.add(method);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getName() {
        return GroovyBundle.message("add.method", this.myMethodName, this.myClassName);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("add.method.family", new Object[0]);
    }

    static String generateTypeText(GrTypeDefinition aClass) {
        String className = aClass.getName();
        LOG.assertTrue(className != null, (Object)aClass);
        StringBuilder returnType2 = new StringBuilder(className);
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            returnType2.append('<');
            for (PsiTypeParameter typeParameter : typeParameters) {
                returnType2.append(typeParameter.getName()).append(", ");
            }
            returnType2.replace(returnType2.length() - 2, returnType2.length(), ">");
        }
        return returnType2.toString();
    }
}

