/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyResultOfAssignmentUsedInspection
extends BaseInspection {
    public boolean inspectClosures = false;

    @Override
    @Nullable
    public JComponent createGroovyOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyBundle.message("checkbox.inspect.anonymous.closures", new Object[0]), "inspectClosures");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.nested.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            if (this.isConfusingAssignmentUsage(grAssignmentExpression)) {
                this.registerError(grAssignmentExpression);
            }
        }

        private boolean isConfusingAssignmentUsage(PsiElement expr) {
            PsiElement parent2 = expr.getParent();
            return !(parent2 instanceof GroovyFile) && (GroovyResultOfAssignmentUsedInspection.this.inspectClosures || !(parent2 instanceof GrClosableBlock)) && PsiUtil.isExpressionUsed(expr);
        }
    }
}

