/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyCommentFix;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyFileCommentFix;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyFileCommentFixKt;
import org.jetbrains.plugins.groovy.codeInspection.SuppressForMemberFix;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovySuppressableInspectionTool
extends LocalInspectionTool {
    @Deprecated(forRemoval=true)
    public GroovySuppressableInspectionTool() {
    }

    public static SuppressQuickFix @NotNull [] getSuppressActions(@NotNull String toolId) {
        if ("GroovyUnusedDeclaration".equals(toolId)) {
            toolId = "unused";
        }
        return new SuppressQuickFix[]{new SuppressByGroovyCommentFix(toolId), new SuppressByGroovyFileCommentFix(toolId), new SuppressForMemberFix(toolId, false), new SuppressForMemberFix(toolId, true)};
    }

    public static boolean isElementToolSuppressedIn(PsiElement place, @NotNull String toolId) {
        return GroovySuppressableInspectionTool.getElementToolSuppressedIn(place, toolId) != null;
    }

    @Nullable
    public static PsiElement getElementToolSuppressedIn(PsiElement place, @NotNull String toolId) {
        PsiElement forUnused;
        if (place == null) {
            return null;
        }
        if ("GroovyUnusedDeclaration".equals(toolId) && (forUnused = GroovySuppressableInspectionTool.getElementToolSuppressedIn(place, "unused")) != null) {
            return forUnused;
        }
        return (PsiElement)ReadAction.compute(() -> {
            GrDocCommentOwner owner;
            PsiElement fileLevelSuppression;
            GrStatement statement = PsiUtil.findEnclosingStatement(place);
            if (statement != null) {
                String text;
                Matcher matcher;
                PsiElement prev;
                for (prev = statement.getPrevSibling(); prev != null && StringUtil.isEmpty((String)prev.getText().trim()); prev = prev.getPrevSibling()) {
                }
                if (prev instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                    return prev;
                }
            }
            if ((fileLevelSuppression = SuppressByGroovyFileCommentFixKt.fileLevelSuppression(place, toolId)) != null) {
                return fileLevelSuppression;
            }
            GrMember member = null;
            GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class);
            if (docComment != null && (owner = docComment.getOwner()) instanceof GrMember) {
                member = (GrMember)((Object)owner);
            }
            if (member == null) {
                member = (GrMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GrMember.class});
            }
            while (member != null) {
                GrModifierList modifierList = member.getModifierList();
                for (String ids : GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation(modifierList)) {
                    if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)toolId)) continue;
                    return modifierList;
                }
                member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)member, GrMember.class);
            }
            return null;
        });
    }

    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(GrModifierList modifierList) {
        if (modifierList == null) {
            return Collections.emptyList();
        }
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation == null) {
            return Collections.emptyList();
        }
        GrAnnotationMemberValue attributeValue = (GrAnnotationMemberValue)annotation.findAttributeValue(null);
        ArrayList<String> result2 = new ArrayList<String>();
        if (attributeValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue annotationMemberValue : ((GrAnnotationArrayInitializer)attributeValue).getInitializers()) {
                String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(annotationMemberValue);
                if (id == null) continue;
                result2.add(id);
            }
        } else {
            String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(attributeValue);
            if (id != null) {
                result2.add(id);
            }
        }
        return result2;
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(GrAnnotationMemberValue element) {
        Object value2;
        if (element instanceof GrLiteral && (value2 = ((GrLiteral)element).getValue()) instanceof String) {
            return (String)value2;
        }
        return null;
    }
}

