/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.ProblemsHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class GroovyLocalInspectionBase
extends GroovyLocalInspectionTool {
    @Override
    @NotNull
    public final GroovyElementVisitor buildGroovyVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        return new GroovyElementVisitor(){

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                GroovyLocalInspectionBase.this.check(closure, problemsHolder);
            }

            @Override
            public void visitLambdaBody(@NotNull GrLambdaBody body) {
                GroovyLocalInspectionBase.this.check(body, problemsHolder);
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    GroovyLocalInspectionBase.this.check(block, problemsHolder);
                }
            }

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                GroovyLocalInspectionBase.this.check(file, problemsHolder);
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                GroovyLocalInspectionBase.this.check(initializer.getBlock(), problemsHolder);
            }
        };
    }

    protected abstract void check(@NotNull GrControlFlowOwner var1, @NotNull ProblemsHolder var2);
}

