/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInsight.template.postfix.GroovyPostfixTemplateUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\u0010J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/groovy/codeInsight/template/postfix/GroovyPostfixTemplateUtils;", "", "()V", "GROOVY_PSI_INFO", "Lcom/intellij/codeInsight/template/postfix/templates/PostfixTemplatePsiInfo;", "getGROOVY_PSI_INFO", "()Lcom/intellij/codeInsight/template/postfix/templates/PostfixTemplatePsiInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "booleanTypeCondition", "", "expr", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getBooleanExpressionSelector", "Lcom/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase;", "getConstructorSelector", "getExpressionSelector", "getGenericExpressionSelector", "org/jetbrains/plugins/groovy/codeInsight/template/postfix/GroovyPostfixTemplateUtils$getGenericExpressionSelector$1", "onlyLast", "condition", "Lcom/intellij/openapi/util/Condition;", "(ZLcom/intellij/openapi/util/Condition;)Lorg/jetbrains/plugins/groovy/codeInsight/template/postfix/GroovyPostfixTemplateUtils$getGenericExpressionSelector$1;", "getIterableExpressionSelector", "getMethodLocalTopExpressionSelector", "getNullableExpressionSelector", "getNullableTopExpressionSelector", "getSubclassExpressionSelector", "baseClassFqn", "", "getTopBooleanExpressionSelector", "getTopExpressionSelector", "nullableTypeCondition", "shouldBeParenthesized", "intellij.groovy"})
public final class GroovyPostfixTemplateUtils {
    @NotNull
    public static final GroovyPostfixTemplateUtils INSTANCE = new GroovyPostfixTemplateUtils();
    @NotNull
    private static final Logger LOG = Logger.getInstance(GroovyPostfixTemplateUtils.class);
    @NotNull
    private static final PostfixTemplatePsiInfo GROOVY_PSI_INFO = new PostfixTemplatePsiInfo(){

        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
            return factory.createExpressionFromText(prefix + context.getText() + suffix, context);
        }

        @NotNull
        public GrExpression getNegatedExpression(@NotNull PsiElement element) {
            GroovyPostfixTemplateUtils.INSTANCE.getLOG().assertTrue(element instanceof GrExpression);
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiExpression");
            String negatedExpressionText = BoolUtils.getNegatedExpressionText((PsiExpression)((PsiExpression)element));
            return GroovyPsiElementFactory.getInstance(element.getProject()).createExpressionFromText(negatedExpressionText, element);
        }
    };

    private GroovyPostfixTemplateUtils() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public final PostfixTemplatePsiInfo getGROOVY_PSI_INFO() {
        return GROOVY_PSI_INFO;
    }

    private final boolean booleanTypeCondition(GrExpression expr) {
        PsiType type2 = expr.getType();
        return type2 == null || Intrinsics.areEqual((Object)type2, (Object)PsiType.BOOLEAN) || type2.equalsToText("java.lang.Boolean");
    }

    private final boolean nullableTypeCondition(GrExpression expr) {
        return !(expr.getType() instanceof PsiPrimitiveType);
    }

    private final getGenericExpressionSelector.1 getGenericExpressionSelector(boolean onlyLast, Condition<? super GrExpression> condition) {
        Condition condition2 = arg_0 -> GroovyPostfixTemplateUtils.getGenericExpressionSelector$lambda$0((Function1)new Function1<PsiElement, Boolean>(condition){
            final /* synthetic */ Condition<? super GrExpression> $condition;
            {
                this.$condition = $condition;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiElement it) {
                return it instanceof GrExpression && this.$condition.value((Object)it);
            }
        }, arg_0);
        return new PostfixTemplateExpressionSelectorBase(onlyLast, (Condition<Object>)condition2){
            final /* synthetic */ boolean $onlyLast;
            {
                this.$onlyLast = $onlyLast;
                super($super_call_param$1);
            }

            @NotNull
            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                int actualOffset = Math.max(offset - 1, 0);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(document);
                if (psiFile == null) {
                    return CollectionsKt.emptyList();
                }
                PsiFile file = psiFile;
                PsiElement currentElement = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)actualOffset, GrExpression.class, (boolean)false);
                List expressions = new ArrayList<E>();
                Condition offsetFilter = this.getBorderOffsetFilter(offset);
                while (currentElement instanceof GrExpression && offsetFilter.value((Object)currentElement)) {
                    expressions.add(currentElement);
                    currentElement = ((GrExpression)currentElement).getParent();
                }
                if (this.$onlyLast) {
                    return CollectionsKt.listOfNotNull((Object)CollectionsKt.lastOrNull((List)expressions));
                }
                return CollectionsKt.toList((Iterable)expressions);
            }
        };
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getExpressionSelector() {
        return this.getGenericExpressionSelector(false, (Condition<? super GrExpression>)Conditions.alwaysTrue());
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getTopExpressionSelector() {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)Conditions.alwaysTrue());
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getNullableTopExpressionSelector() {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getNullableTopExpressionSelector$lambda$1((Function1)new Function1<GrExpression, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GrExpression p0) {
                return GroovyPostfixTemplateUtils.access$nullableTypeCondition((GroovyPostfixTemplateUtils)this.receiver, p0);
            }
        }, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getNullableExpressionSelector() {
        return this.getGenericExpressionSelector(false, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getNullableExpressionSelector$lambda$2((Function1)new Function1<GrExpression, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GrExpression p0) {
                return GroovyPostfixTemplateUtils.access$nullableTypeCondition((GroovyPostfixTemplateUtils)this.receiver, p0);
            }
        }, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getMethodLocalTopExpressionSelector() {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getMethodLocalTopExpressionSelector$lambda$3(getMethodLocalTopExpressionSelector.1.INSTANCE, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getTopBooleanExpressionSelector() {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getTopBooleanExpressionSelector$lambda$4((Function1)new Function1<GrExpression, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GrExpression p0) {
                return GroovyPostfixTemplateUtils.access$booleanTypeCondition((GroovyPostfixTemplateUtils)this.receiver, p0);
            }
        }, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getBooleanExpressionSelector() {
        return this.getGenericExpressionSelector(false, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getBooleanExpressionSelector$lambda$5((Function1)new Function1<GrExpression, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull GrExpression p0) {
                return GroovyPostfixTemplateUtils.access$booleanTypeCondition((GroovyPostfixTemplateUtils)this.receiver, p0);
            }
        }, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getSubclassExpressionSelector(@NotNull String baseClassFqn) {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getSubclassExpressionSelector$lambda$6((Function1)new Function1<GrExpression, Boolean>(baseClassFqn){
            final /* synthetic */ String $baseClassFqn;
            {
                this.$baseClassFqn = $baseClassFqn;
                super(1);
            }

            @NotNull
            public final Boolean invoke(GrExpression expr) {
                PsiType type2 = expr.getType();
                return type2 == null || InheritanceUtil.isInheritor((PsiType)type2, (String)this.$baseClassFqn);
            }
        }, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getIterableExpressionSelector() {
        return this.getGenericExpressionSelector(true, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getIterableExpressionSelector$lambda$7(getIterableExpressionSelector.1.INSTANCE, arg_0)));
    }

    @NotNull
    public final PostfixTemplateExpressionSelectorBase getConstructorSelector() {
        return this.getGenericExpressionSelector(false, (Condition<? super GrExpression>)((Condition)arg_0 -> GroovyPostfixTemplateUtils.getConstructorSelector$lambda$8(getConstructorSelector.1.INSTANCE, arg_0)));
    }

    public final boolean shouldBeParenthesized(@NotNull GrExpression expr) {
        GrExpression grExpression = expr;
        return grExpression instanceof GrOperatorExpression ? true : (grExpression instanceof GrConditionalExpression ? true : (grExpression instanceof GrSafeCastExpression ? true : (grExpression instanceof GrMethodCallExpression ? ((GrMethodCallExpression)expr).getArgumentList().getLeftParen() == null && ((GrMethodCallExpression)expr).getArgumentList().getRightParen() == null : false)));
    }

    private static final boolean getGenericExpressionSelector$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getNullableTopExpressionSelector$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getNullableExpressionSelector$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getMethodLocalTopExpressionSelector$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getTopBooleanExpressionSelector$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getBooleanExpressionSelector$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getSubclassExpressionSelector$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getIterableExpressionSelector$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getConstructorSelector$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$nullableTypeCondition(GroovyPostfixTemplateUtils $this, GrExpression expr) {
        return $this.nullableTypeCondition(expr);
    }

    public static final /* synthetic */ boolean access$booleanTypeCondition(GroovyPostfixTemplateUtils $this, GrExpression expr) {
        return $this.booleanTypeCondition(expr);
    }
}

