/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.hint.types;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInsight.hint.types.GroovyLocalVariableTypeHintsInlayProvider;
import org.jetbrains.plugins.groovy.codeInsight.hint.types.GroovyTypeHintsUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/codeInsight/hint/types/GroovyLocalVariableTypeHintsCollector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "Lorg/jetbrains/plugins/groovy/codeInsight/hint/types/GroovyLocalVariableTypeHintsInlayProvider$Settings;", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/plugins/groovy/codeInsight/hint/types/GroovyLocalVariableTypeHintsInlayProvider$Settings;)V", "getSettings", "()Lorg/jetbrains/plugins/groovy/codeInsight/hint/types/GroovyLocalVariableTypeHintsInlayProvider$Settings;", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getVariableTypes", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/psi/PsiIdentifier;", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "submitInlayHint", "", "identifier", "type", "intellij.groovy"})
public final class GroovyLocalVariableTypeHintsCollector
extends FactoryInlayHintsCollector {
    @NotNull
    private final GroovyLocalVariableTypeHintsInlayProvider.Settings settings;

    public GroovyLocalVariableTypeHintsCollector(@NotNull Editor editor, @NotNull GroovyLocalVariableTypeHintsInlayProvider.Settings settings) {
        super(editor);
        this.settings = settings;
    }

    @NotNull
    public final GroovyLocalVariableTypeHintsInlayProvider.Settings getSettings() {
        return this.settings;
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        if (!element.isValid() || element.getProject().isDefault()) {
            return false;
        }
        if (element instanceof GrParameter) {
            return true;
        }
        if (!(element instanceof GrVariableDeclaration)) {
            return true;
        }
        List<Pair<PsiType, PsiIdentifier>> variableTypes = this.getVariableTypes((GrVariableDeclaration)element);
        for (Pair<PsiType, PsiIdentifier> pair : variableTypes) {
            PsiType type2 = (PsiType)pair.component1();
            PsiIdentifier identifier = (PsiIdentifier)pair.component2();
            this.submitInlayHint(identifier, type2, sink);
        }
        return true;
    }

    private final void submitInlayHint(PsiIdentifier identifier, PsiType type2, InlayHintsSink sink) {
        Pair pair;
        TextRange textRange = identifier.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange identifierRange = textRange;
        InlayPresentation typeRepresentation = GroovyTypeHintsUtilKt.buildRepresentation(this.getFactory(), type2);
        if (this.settings.getInsertBeforeIdentifier()) {
            var7_6 = new InlayPresentation[]{typeRepresentation, this.getFactory().smallText(" ")};
            pair = TuplesKt.to((Object)identifierRange.getStartOffset(), (Object)this.getFactory().seq(var7_6));
        } else {
            var7_6 = new InlayPresentation[]{this.getFactory().smallText(": "), typeRepresentation};
            pair = TuplesKt.to((Object)identifierRange.getEndOffset(), (Object)this.getFactory().seq(var7_6));
        }
        Pair pair2 = pair;
        int offset = ((Number)pair2.component1()).intValue();
        InlayPresentation representation = (InlayPresentation)pair2.component2();
        sink.addInlineElement(offset, true, this.getFactory().roundWithBackground(representation), false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<PsiType, PsiIdentifier>> getVariableTypes(GrVariableDeclaration variableDeclaration) {
        void $this$filterTo$iv$iv;
        Pair pair;
        List list;
        if (!variableDeclaration.isTuple()) {
            GroovyPsiElement groovyPsiElement = (GrVariable)ArraysKt.singleOrNull((Object[])variableDeclaration.getVariables());
            if (groovyPsiElement == null || (groovyPsiElement = groovyPsiElement.getInitializerGroovy()) == null) {
                return CollectionsKt.emptyList();
            }
            GroovyPsiElement initializer = groovyPsiElement;
            if (initializer instanceof GrConstructorCall || initializer instanceof GrSafeCastExpression || initializer instanceof GrTypeCastExpression || initializer instanceof GrOperatorExpression) {
                return CollectionsKt.emptyList();
            }
        }
        Pair $this$mapSmart$iv = variableDeclaration.getVariables();
        boolean $i$f$mapSmart = false;
        int size$iv22 = ((GrVariable[])$this$mapSmart$iv).length;
        switch (size$iv22) {
            case 1: {
                PsiIdentifier identifier;
                Pair pair2;
                GrVariable it = $this$mapSmart$iv[0];
                int n = 0;
                if (it instanceof GrField || it.getTypeElementGroovy() != null) {
                    pair2 = null;
                } else {
                    PsiType psiType = it.getTypeGroovy();
                    if (psiType == null) {
                        pair2 = null;
                    } else {
                        PsiType type2 = psiType;
                        PsiIdentifier psiIdentifier = it.getNameIdentifier();
                        if (psiIdentifier == null) {
                            pair2 = null;
                        } else {
                            identifier = psiIdentifier;
                            pair2 = TuplesKt.to((Object)type2, (Object)identifier);
                        }
                    }
                }
                Pair pair3 = pair2;
                list = (List)new SmartList(pair3);
                break;
            }
            case 0: {
                list = (List)new SmartList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                PsiIdentifier identifier;
                pair = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv22);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    PsiIdentifier identifier2;
                    PsiType type3;
                    void it;
                    identifier = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it instanceof GrField || it.getTypeElementGroovy() != null ? null : (it.getTypeGroovy() == null ? null : (it.getNameIdentifier() == null ? null : TuplesKt.to((Object)type3, (Object)identifier2))));
                }
                list = (List)destination$iv$iv;
            }
        }
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$filter = false;
        Iterable size$iv22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            PsiType type4 = (PsiType)pair.component1();
            boolean bl2 = !(Intrinsics.areEqual((Object)type4, (Object)PsiType.NULL) || Intrinsics.areEqual((Object)type4, (Object)PsiType.VOID) || type4.equalsToText("java.lang.Object"));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

