/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.TemplatesKt;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/MethodRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "abstract", "", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "(Lcom/intellij/openapi/project/Project;ZLorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateMethodRequest;)V", "getAbstract", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "execute", "", "insertMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "method", "renderMethod", "setupTemplate", "intellij.groovy"})
final class MethodRenderer {
    @NotNull
    private final Project project;
    private final boolean abstract;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateMethodRequest request;

    public MethodRenderer(@NotNull Project project, boolean bl, @NotNull GrTypeDefinition targetClass, @NotNull CreateMethodRequest request) {
        this.project = project;
        this.abstract = bl;
        this.targetClass = targetClass;
        this.request = request;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getAbstract() {
        return this.abstract;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateMethodRequest getRequest() {
        return this.request;
    }

    public final void execute() {
        GrMethod method = this.renderMethod();
        method = this.insertMethod(method);
        GrMethod grMethod = (GrMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        if (grMethod == null) {
            return;
        }
        method = grMethod;
        this.setupTemplate(method);
    }

    private final void setupTemplate(GrMethod method) {
        List parameters2 = this.request.getExpectedParameters();
        Collection $this$toTypedArray$iv = TemplatesKt.setupParameters(method, parameters2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ChooseTypeExpression[] typeExpressions = thisCollection$iv.toArray(new ChooseTypeExpression[0]);
        Collection $this$toTypedArray$iv2 = TemplatesKt.setupNameExpressions(parameters2, this.project);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        ParameterNameExpression[] nameExpressions = thisCollection$iv2.toArray(new ParameterNameExpression[0]);
        ChooseTypeExpression returnExpression = TemplatesKt.setupTypeElement(method, JvmPsiUtilKt.createConstraints(this.project, this.request.getReturnType()));
        IntentionUtils.createTemplateForMethod(typeExpressions, nameExpressions, method, this.targetClass, returnExpression, false, null);
    }

    @NotNull
    public final GrMethod renderMethod() {
        GrMethod method;
        block7: {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.project);
            method = factory.createMethod(this.request.getMethodName(), (PsiType)PsiType.VOID);
            List modifiersToRender = CollectionsKt.toMutableList((Collection)this.request.getModifiers());
            if (this.targetClass.isInterface()) {
                CollectionsKt.removeAll((Collection)modifiersToRender, (Iterable)SetsKt.plus(JvmPsiUtilKt.getVisibilityModifiers(), (Object)JvmModifier.ABSTRACT));
            } else if (this.abstract) {
                if (modifiersToRender.remove(JvmModifier.PRIVATE)) {
                    ((Collection)modifiersToRender).add(JvmModifier.PROTECTED);
                }
                ((Collection)modifiersToRender).add(JvmModifier.ABSTRACT);
            }
            ((Collection)modifiersToRender).remove(JvmModifier.PUBLIC);
            GrModifierList modifierList = method.getModifierList();
            for (JvmModifier modifier : modifiersToRender) {
                modifierList.setModifierProperty(JvmPsiUtilKt.toPsiModifier(modifier), true);
            }
            modifierList.setModifierProperty("def", true);
            for (AnnotationRequest annotation : this.request.getAnnotations()) {
                modifierList.addAnnotation(annotation.getQualifiedName());
            }
            if (!this.abstract) break block7;
            PsiCodeBlock psiCodeBlock = method.getBody();
            if (psiCodeBlock != null) {
                psiCodeBlock.delete();
            }
        }
        return method;
    }

    private final GrMethod insertMethod(GrMethod method) {
        PsiElement psiElement = this.targetClass.add(method);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        return (GrMethod)psiElement;
    }
}

