/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.lang.jvm.actions.CreateEnumConstantActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateEnumConstantActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateEnumConstantAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldActionBase;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getEnumConstantTriple", "Lkotlin/Triple;", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrEnumConstant;", "getText", "invoke", "", "intellij.groovy"})
public final class CreateEnumConstantAction
extends CreateFieldActionBase {
    @NotNull
    private final CreateFieldRequest request;

    public CreateEnumConstantAction(@NotNull GrTypeDefinition target, @NotNull CreateFieldRequest request) {
        super(target, request);
        this.request = request;
    }

    @Override
    @NotNull
    protected CreateFieldRequest getRequest() {
        return this.request;
    }

    @NotNull
    public JvmActionGroup getActionGroup() {
        return (JvmActionGroup)CreateEnumConstantActionGroup.INSTANCE;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.getRequest().getFieldName()};
        return GroovyBundle.message("intention.name.create.enum.constant.0", objectArray);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        GrEnumConstant constant = (GrEnumConstant)this.getEnumConstantTriple(project).component3();
        GrTypeDefinition grTypeDefinition = (GrTypeDefinition)this.getMyTargetPointer().getElement();
        String className = grTypeDefinition != null ? grTypeDefinition.getName() : null;
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, className, "", constant.getText());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Triple<GrTypeDefinition, String, GrEnumConstant> triple = this.getEnumConstantTriple(project);
        GrTypeDefinition targetClass = (GrTypeDefinition)triple.component1();
        String parameters2 = (String)triple.component2();
        GrEnumConstant enumConstant = (GrEnumConstant)triple.component3();
        PsiElement psiElement = targetClass.add(enumConstant);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant");
        GrEnumConstant added = (GrEnumConstant)psiElement;
        if (((CharSequence)parameters2).length() == 0) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)added);
        GrArgumentList grArgumentList = added.getArgumentList();
        Intrinsics.checkNotNull((Object)grArgumentList);
        GrArgumentList argumentList = grArgumentList;
        for (GrExpression expression : argumentList.getExpressionArguments()) {
            builder.replaceElement((PsiElement)expression, (Expression)new EmptyExpression());
        }
        GrEnumConstant grEnumConstant = (GrEnumConstant)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)added);
        if (grEnumConstant == null) {
            return;
        }
        added = grEnumConstant;
        Template template = builder.buildTemplate();
        Editor editor2 = CreateFromUsageBaseFix.positionCursor((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiElement)added);
        if (editor2 == null) {
            return;
        }
        Editor newEditor = editor2;
        TextRange range = added.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        CreateFromUsageBaseFix.startTemplate((Editor)newEditor, (Template)template, (Project)project);
    }

    private final Triple<GrTypeDefinition, String, GrEnumConstant> getEnumConstantTriple(Project project) {
        String name = this.getRequest().getFieldName();
        GrTypeDefinition targetClass = this.getTarget();
        String parameters2 = CreateEnumConstantActionKt.renderParameters(targetClass);
        String text = ((CharSequence)parameters2).length() == 0 ? name : name + "(" + parameters2 + ")";
        GrEnumConstant enumConstant = CreateEnumConstantActionKt.renderConstant(project, text);
        return new Triple((Object)targetClass, (Object)parameters2, (Object)enumConstant);
    }
}

