/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ReplaceDotFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "oldDot", "Lcom/intellij/psi/tree/IElementType;", "newDot", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;)V", "myName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getMyName", "()Ljava/lang/String;", "getOldDot", "()Lcom/intellij/psi/tree/IElementType;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.groovy.psi"})
public final class ReplaceDotFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final IElementType oldDot;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final IElementType newDot;

    public ReplaceDotFix(@NotNull IElementType oldDot, @NotNull IElementType newDot) {
        this.oldDot = oldDot;
        this.newDot = newDot;
    }

    @NotNull
    public final IElementType getOldDot() {
        return this.oldDot;
    }

    private final String getMyName() {
        Object[] objectArray = new Object[]{this.oldDot, this.newDot};
        return GroovyBundle.message("intention.family.name.replace.something.with", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getMyName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null || (psiElement = psiElement.getNode()) == null) {
            return;
        }
        PsiElement oldNode = psiElement;
        LeafElement newNode = ASTFactory.leaf((IElementType)this.newDot, (CharSequence)this.newDot.toString());
        CodeEditUtil.setNodeGenerated((ASTNode)((ASTNode)newNode), (boolean)true);
        oldNode.getTreeParent().replaceChild((ASTNode)oldNode, (ASTNode)newNode);
    }
}

