/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAddImportAction
extends ImportClassFixBase<GrReferenceElement<?>, GrReferenceElement<?>> {
    private final GrReferenceElement<?> ref;

    public GroovyAddImportAction(@NotNull GrReferenceElement<?> ref2) {
        super(ref2, ref2);
        this.ref = ref2;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiFile containingFile = this.ref.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return IntentionPreviewInfo.EMPTY;
        }
        String fileName = containingFile.getName();
        GrImportStatement[] imports2 = ((GroovyFile)containingFile).getImportStatements();
        StringBuilder builder = new StringBuilder();
        for (GrImportStatement importStmt : imports2) {
            builder.append(importStmt.getText());
            builder.append("\n");
        }
        String before = builder.toString();
        builder.append("import package1.package2.").append(this.ref.getReferenceName());
        String after = builder.toString();
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, fileName, before, after);
    }

    protected String getReferenceName(@NotNull GrReferenceElement<?> reference) {
        return reference.getReferenceName();
    }

    protected PsiElement getReferenceNameElement(@NotNull GrReferenceElement<?> reference) {
        return reference.getReferenceNameElement();
    }

    protected boolean hasTypeParameters(@NotNull GrReferenceElement<?> reference) {
        return reference.getTypeArguments().length > 0;
    }

    protected String getQualifiedName(@NotNull GrReferenceElement<?> referenceElement) {
        return referenceElement.getCanonicalText();
    }

    protected boolean isQualified(@NotNull GrReferenceElement<?> reference) {
        return reference.getQualifier() != null;
    }

    protected boolean hasUnresolvedImportWhichCanImport(@NotNull PsiFile psiFile, @NotNull String name) {
        GrImportStatement[] importStatements;
        if (!(psiFile instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement importStatement : importStatements = ((GroovyFile)psiFile).getImportStatements()) {
            GrCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null || importReference.resolve() != null || !importStatement.isOnDemand() && !Comparing.strEqual((String)importStatement.getImportedName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Collection<PsiClass> filterByContext(@NotNull Collection<PsiClass> candidates, @NotNull GrReferenceElement<?> referenceElement) {
        PsiElement typeElement = referenceElement.getParent();
        if (typeElement instanceof GrTypeElement) {
            PsiType type2;
            PsiExpression initializer;
            GrVariable[] vars;
            PsiElement decl = typeElement.getParent();
            if (decl instanceof GrVariableDeclaration && (vars = ((GrVariableDeclaration)decl).getVariables()).length == 1 && (initializer = vars[0].getInitializer()) != null && (type2 = initializer.getType()) != null) {
                return GroovyAddImportAction.filterAssignableFrom((PsiType)type2, candidates);
            }
            if (decl instanceof GrParameter) {
                return GroovyAddImportAction.filterBySuperMethods((PsiParameter)((PsiParameter)decl), candidates);
            }
        }
        return super.filterByContext(candidates, referenceElement);
    }

    protected String getRequiredMemberName(@NotNull GrReferenceElement<?> referenceElement) {
        if (referenceElement.getParent() instanceof GrReferenceElement) {
            return ((GrReferenceElement)referenceElement.getParent()).getReferenceName();
        }
        return super.getRequiredMemberName(referenceElement);
    }

    protected boolean isAccessible(@NotNull PsiMember member, @NotNull GrReferenceElement<?> referenceElement) {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (!this.ref.isValid()) {
            return false;
        }
        PsiFile containingFile = this.ref.getContainingFile();
        if (containingFile instanceof GroovyFile) {
            List alreadyImportedClasses = ContainerUtil.map((Object[])((GroovyFile)containingFile).getImportStatements(), GrImportStatement::resolveTargetClass);
            for (PsiClass classToImport : this.getClassesToImport()) {
                if (!alreadyImportedClasses.contains(classToImport)) continue;
                return false;
            }
        }
        return super.showHint(editor);
    }

    protected void bindReference(@NotNull PsiReference reference, @NotNull PsiClass targetClass) {
        PsiElement referringElement = reference.getElement();
        if (referringElement.getParent() instanceof GrMethodCall && referringElement instanceof GrReferenceExpression && PsiUtil.isNewified(referringElement)) {
            GroovyAddImportAction.handleNewifiedClass(referringElement, targetClass);
        } else {
            super.bindReference(reference, targetClass);
        }
    }

    private static void handleNewifiedClass(@NotNull PsiElement referringElement, @NotNull PsiClass targetClass) {
        PsiFile file = referringElement.getContainingFile();
        if (file instanceof GroovyFile) {
            ((GroovyFile)file).importClass(targetClass);
        }
    }

    protected boolean isClassMaybeImportedAlready(@NotNull PsiFile containingFile, @NotNull PsiClass classToImport) {
        GrImportStatement[] importList = ((GroovyFile)containingFile).getImportStatements();
        if (importList == null) {
            return false;
        }
        String classQualifiedName = classToImport.getQualifiedName();
        String packageName = classQualifiedName == null ? "" : StringUtil.getPackageName((String)classQualifiedName);
        boolean result2 = false;
        for (GrImportStatement statement : importList) {
            GrCodeReferenceElement importRef = statement.getImportReference();
            if (importRef == null) continue;
            String canonicalText = importRef.getCanonicalText();
            if (statement.isOnDemand()) {
                if (!canonicalText.equals(packageName)) continue;
                result2 = true;
                break;
            }
            if (!canonicalText.equals(classQualifiedName)) continue;
            result2 = true;
            break;
        }
        return result2;
    }
}

