/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrRemoveExceptionFix
implements IntentionAction {
    @IntentionName
    private final String myText;
    private final boolean myDisjunction;

    public GrRemoveExceptionFix(boolean isDisjunction) {
        this.myDisjunction = isDisjunction;
        this.myText = isDisjunction ? GroovyBundle.message("remove.exception", new Object[0]) : GroovyBundle.message("remove.catch.block", new Object[0]);
    }

    @NotNull
    @IntentionName
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("try.catch.fix", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myDisjunction && GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file) != null || !this.myDisjunction && GrRemoveExceptionFix.findCatch(editor, file) != null;
    }

    @Nullable
    private static GrTypeElement findTypeElementInDisjunction(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        GrDisjunctionTypeElement disjunction = (GrDisjunctionTypeElement)PsiTreeUtil.getParentOfType((PsiElement)at, GrDisjunctionTypeElement.class);
        if (disjunction == null) {
            return null;
        }
        for (GrTypeElement element : disjunction.getTypeElements()) {
            if (!element.getTextRange().contains(offset)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static GrCatchClause findCatch(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        return (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)at, GrCatchClause.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (this.myDisjunction) {
            GrTypeElement element = GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file);
            if (element != null) {
                element.delete();
            }
        } else {
            GrCatchClause aCatch = GrRemoveExceptionFix.findCatch(editor, file);
            if (aCatch != null) {
                aCatch.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

