/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/GrChangeModifiersFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "modifiersToRemove", "", "", "modifierToInsert", "textRepresentation", "removeModifierUnderCaret", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "startInWriteAction", "intellij.groovy.psi"})
public final class GrChangeModifiersFix
implements IntentionAction {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<String> modifiersToRemove;
    @Nullable
    private final String modifierToInsert;
    @NotNull
    private final String textRepresentation;
    private final boolean removeModifierUnderCaret;

    public GrChangeModifiersFix(@NotNull List<String> modifiersToRemove, @Nullable String modifierToInsert, @Nls @NotNull String textRepresentation, boolean removeModifierUnderCaret) {
        this.modifiersToRemove = modifiersToRemove;
        this.modifierToInsert = modifierToInsert;
        this.textRepresentation = textRepresentation;
        this.removeModifierUnderCaret = removeModifierUnderCaret;
    }

    public /* synthetic */ GrChangeModifiersFix(List list, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list, string, string2, bl);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return this.textRepresentation;
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("intention.family.name.replace.modifiers", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (editor == null) {
            return false;
        }
        return file != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        block13: {
            PsiModifierListOwner owner;
            block14: {
                PsiElement[] psiElementArray;
                String elementUnderCaretRepresentation;
                block12: {
                    block11: {
                        PsiElement elementUnderCaret;
                        if (editor == null) {
                            return;
                        }
                        if (file == null) {
                            return;
                        }
                        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
                        if (psiElement == null) {
                            return;
                        }
                        PsiElement $this$parentOfType_u24default$iv = elementUnderCaret = psiElement;
                        boolean withSelf$iv = false;
                        boolean $i$f$parentOfType = false;
                        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiModifierListOwner.class, (boolean)true);
                        if (psiModifierListOwner == null) {
                            return;
                        }
                        owner = psiModifierListOwner;
                        elementUnderCaretRepresentation = elementUnderCaret.getText();
                        psiElementArray = owner.getModifierList();
                        if (psiElementArray == null) break block11;
                        PsiElement[] $this$asSafely$iv = psiElementArray;
                        boolean $i$f$asSafely = false;
                        PsiElement[] psiElementArray2 = $this$asSafely$iv;
                        if (!($this$asSafely$iv instanceof GrModifierList)) {
                            psiElementArray2 = null;
                        }
                        if ((psiElementArray = (PsiElement[])psiElementArray2) != null && (psiElementArray = psiElementArray.getModifiers()) != null) break block12;
                    }
                    return;
                }
                PsiElement[] modifiers = psiElementArray;
                boolean hasRequiredModifier = false;
                for (PsiElement modifier : modifiers) {
                    String modifierRepresentation;
                    String string = modifierRepresentation = modifier instanceof PsiAnnotation ? ((PsiAnnotation)modifier).getQualifiedName() : modifier.getText();
                    if (Intrinsics.areEqual((Object)modifierRepresentation, (Object)this.modifierToInsert)) {
                        hasRequiredModifier = true;
                    }
                    if (!this.removeModifierUnderCaret && Intrinsics.areEqual((Object)modifierRepresentation, (Object)elementUnderCaretRepresentation) || !CollectionsKt.contains((Iterable)this.modifiersToRemove, (Object)modifierRepresentation)) continue;
                    modifier.delete();
                }
                if (hasRequiredModifier || this.modifierToInsert == null) break block13;
                if (!ArraysKt.contains((Object[])GrModifier.GROOVY_MODIFIERS, (Object)this.modifierToInsert) && !ArraysKt.contains((Object[])PsiModifier.MODIFIERS, (Object)this.modifierToInsert)) break block14;
                PsiModifierList psiModifierList = owner.getModifierList();
                if (psiModifierList == null) break block13;
                psiModifierList.setModifierProperty(this.modifierToInsert, true);
                break block13;
            }
            PsiModifierList psiModifierList = owner.getModifierList();
            if (psiModifierList == null) break block13;
            psiModifierList.addAnnotation(this.modifierToInsert);
        }
    }
}

