/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CreateSetterFromUsageFix
extends CreateMethodFromUsageFix
implements LowPriorityAction {
    public CreateSetterFromUsageFix(@NotNull GrReferenceExpression refExpression) {
        super(refExpression);
    }

    @Override
    protected TypeConstraint @NotNull [] getReturnTypeConstraints() {
        return new TypeConstraint[]{SubtypeConstraint.create((PsiType)PsiType.VOID)};
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrReferenceExpression expr = this.getRefExpr();
        if (expr == null) {
            return null;
        }
        return new CreateSetterFromUsageFix(expr);
    }

    @Override
    protected PsiType[] getArgumentTypes() {
        GrReferenceExpression ref2 = this.getRefExpr();
        assert (PsiUtil.isLValue(ref2));
        PsiType initializer = TypeInferenceHelper.getInitializerTypeFor(ref2);
        if (initializer == null || initializer == PsiType.NULL) {
            initializer = TypesUtil.getJavaLangObject(ref2);
        }
        return new PsiType[]{initializer};
    }

    @Override
    @NotNull
    protected String getMethodName() {
        return GroovyPropertyUtils.getSetterName(this.getRefExpr().getReferenceName());
    }
}

