/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class CreateGetterFromUsageFix
extends CreateMethodFromUsageFix
implements LowPriorityAction {
    public CreateGetterFromUsageFix(@NotNull GrReferenceExpression refExpression) {
        super(refExpression);
    }

    @Override
    protected TypeConstraint @NotNull [] getReturnTypeConstraints() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrReferenceExpression expr = this.getRefExpr();
        if (expr == null) {
            return null;
        }
        return new CreateGetterFromUsageFix(expr);
    }

    @Override
    protected PsiType[] getArgumentTypes() {
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getMethodName() {
        return GroovyPropertyUtils.getGetterNameNonBoolean(this.getRefExpr().getReferenceName());
    }
}

