/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;

public class CreateFieldFromUsageFix
extends GrCreateFromUsageBaseFix {
    @NotNull
    private final String myReferenceName;

    public CreateFieldFromUsageFix(GrReferenceExpression refExpression, @NotNull String referenceName) {
        super(refExpression);
        this.myReferenceName = referenceName;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement parent2;
        List<PsiClass> classes2 = this.getTargetClasses();
        if (classes2.size() == 0) {
            return IntentionPreviewInfo.EMPTY;
        }
        PsiClass targetClass = classes2.get(0);
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        PsiField representation = fix.getFieldRepresentation(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.getRefExpr(), true);
        PsiElement psiElement = parent2 = representation == null ? null : representation.getParent();
        if (parent2 == null) {
            return IntentionPreviewInfo.EMPTY;
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, "", parent2.getText());
    }

    private String[] generateModifiers(@NotNull PsiClass targetClass) {
        GrReferenceExpression myRefExpression = this.getRefExpr();
        if (myRefExpression != null && GrStaticChecker.isInStaticContext(myRefExpression, targetClass)) {
            return new String[]{"static"};
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("create.field.from.usage.family.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyBundle.message("create.field.from.usage", this.myReferenceName);
    }

    @Override
    protected void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        fix.doFix(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.calculateTypeConstrains(), this.getRefExpr());
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return super.canBeTargetClass(psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }
}

