/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public abstract class CreateClassFix {
    public static IntentionAction createClassFromNewAction(GrNewExpression expression) {
        return new CreateClassActionBase(GrCreateClassKind.CLASS, expression.getReferenceElement()){

            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                PsiFile file = element.getContainingFile();
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiManager manager = this.myRefElement.getManager();
                String qualifier = (String)ReadAction.compute(() -> groovyFile instanceof GroovyFile ? groovyFile.getPackageName() : "");
                String name = (String)ReadAction.compute(() -> this.myRefElement.getReferenceName());
                assert (name != null);
                Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
                PsiDirectory targetDirectory = this.getTargetDirectory(project, qualifier, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                GrTypeDefinition targetClass = 1.createClassByType(targetDirectory, name, manager, this.myRefElement, "Groovy Class.groovy", true);
                if (targetClass == null) {
                    return;
                }
                PsiType[] argTypes = CreateClassFix.getArgTypes(this.myRefElement);
                if (argTypes != null && argTypes.length > 0) {
                    CreateClassFix.generateConstructor(this.myRefElement, name, argTypes, targetClass, project);
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                } else {
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                    IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
                }
            }
        };
    }

    private static PsiType @Nullable [] getArgTypes(GrReferenceElement refElement) {
        return (PsiType[])ReadAction.compute(() -> PsiUtil.getArgumentTypes(refElement, false));
    }

    private static void generateConstructor(@NotNull PsiElement refElement, @NotNull String name, PsiType @NotNull [] argTypes, @NotNull GrTypeDefinition targetClass, @NotNull Project project) {
        WriteAction.run(() -> {
            ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
            String[] paramTypes = new String[argTypes.length];
            String[] paramNames = new String[argTypes.length];
            for (int i2 = 0; i2 < argTypes.length; ++i2) {
                PsiType argType = argTypes[i2];
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(refElement);
                }
                paramTypes[i2] = "Object";
                paramNames[i2] = "o" + i2;
                TypeConstraint[] constraints = new TypeConstraint[]{SupertypeConstraint.create(argType)};
                paramTypesExpressions[i2] = new ChooseTypeExpression(constraints, refElement.getManager(), targetClass.getResolveScope());
            }
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createConstructorFromText(name, paramTypes, paramNames, "{\n}");
            method = (GrMethod)targetClass.addBefore(method, null);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)refElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiFile.class});
            IntentionUtils.createTemplateForMethod(paramTypesExpressions, method, targetClass, TypeConstraint.EMPTY_ARRAY, true, context);
        });
    }

    public static IntentionAction createClassFixAction(GrReferenceElement refElement, GrCreateClassKind type2) {
        return new CreateClassActionBase(type2, refElement){

            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                PsiFile file = element.getContainingFile();
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiElement qualifier = this.myRefElement.getQualifier();
                if (qualifier == null || qualifier instanceof GrReferenceElement && ((GrReferenceElement)qualifier).resolve() instanceof PsiPackage) {
                    this.createTopLevelClass(project, groovyFile);
                } else {
                    this.createInnerClass(project, editor, qualifier);
                }
            }

            private void createInnerClass(Project project, Editor editor, PsiElement qualifier) {
                PsiElement resolved = this.resolveQualifier(qualifier);
                if (!(resolved instanceof PsiClass)) {
                    return;
                }
                JVMElementFactory factory = JVMElementFactories.getFactory((Language)resolved.getLanguage(), (Project)project);
                if (factory == null) {
                    return;
                }
                String name = this.myRefElement.getReferenceName();
                PsiClass template = this.createTemplate(factory, name);
                if (template == null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (editor != null && editor.getComponent().isDisplayable()) {
                            HintManager.getInstance().showErrorHint(editor, GroovyBundle.message("cannot.create.class", new Object[0]));
                        }
                    });
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(resolved)) {
                    return;
                }
                WriteAction.run(() -> {
                    PsiClass added = (PsiClass)resolved.add((PsiElement)template);
                    PsiModifierList modifierList = added.getModifierList();
                    if (modifierList != null) {
                        modifierList.setModifierProperty("static", true);
                    }
                    IntentionUtils.positionCursor(project, added.getContainingFile(), (PsiElement)added);
                });
            }

            @Nullable
            private PsiElement resolveQualifier(@NotNull PsiElement qualifier) {
                if (qualifier instanceof GrCodeReferenceElement) {
                    return ((GrCodeReferenceElement)qualifier).resolve();
                }
                if (qualifier instanceof GrExpression) {
                    PsiElement resolved;
                    PsiType type2 = ((GrExpression)qualifier).getType();
                    if (type2 instanceof PsiClassType) {
                        return ((PsiClassType)type2).resolve();
                    }
                    if (qualifier instanceof GrReferenceExpression && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || resolved instanceof PsiPackage)) {
                        return resolved;
                    }
                }
                return null;
            }

            @Nullable
            private PsiClass createTemplate(JVMElementFactory factory, String name) {
                return switch (this.getType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case GrCreateClassKind.ENUM -> factory.createEnum(name);
                    case GrCreateClassKind.TRAIT -> {
                        if (factory instanceof GroovyPsiElementFactory) {
                            GroovyPsiElementFactory groovyFactory = (GroovyPsiElementFactory)factory;
                            yield groovyFactory.createTrait(name);
                        }
                        yield null;
                    }
                    case GrCreateClassKind.CLASS -> factory.createClass(name);
                    case GrCreateClassKind.INTERFACE -> factory.createInterface(name);
                    case GrCreateClassKind.ANNOTATION -> factory.createAnnotationType(name);
                    case GrCreateClassKind.RECORD -> {
                        if (factory instanceof GroovyPsiElementFactory) {
                            GroovyPsiElementFactory groovyFactory = (GroovyPsiElementFactory)factory;
                            yield groovyFactory.createRecord(name);
                        }
                        yield null;
                    }
                };
            }

            private void createTopLevelClass(@NotNull Project project, @NotNull GroovyFileBase file) {
                String pack = this.getPackage(file);
                PsiManager manager = PsiManager.getInstance((Project)project);
                String name = this.myRefElement.getReferenceName();
                assert (name != null);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                PsiDirectory targetDirectory = this.getTargetDirectory(project, pack, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                String templateName = CreateClassFix.getTemplateName(this.getType());
                GrTypeDefinition targetClass = 2.createClassByType(targetDirectory, name, manager, this.myRefElement, templateName, true);
                if (targetClass == null) {
                    return;
                }
                CreateClassFix.bindRef(targetClass, this.myRefElement);
                IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
            }

            @NotNull
            private String getPackage(@NotNull PsiClassOwner file) {
                PsiElement resolved;
                PsiElement qualifier = this.myRefElement.getQualifier();
                if (qualifier instanceof GrReferenceElement && (resolved = ((GrReferenceElement)qualifier).resolve()) instanceof PsiPackage) {
                    return ((PsiPackage)resolved).getQualifiedName();
                }
                return file instanceof GroovyFile ? file.getPackageName() : "";
            }

            @Override
            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (!super.isAvailable(project, editor, file)) {
                    return false;
                }
                PsiElement qualifier = this.myRefElement.getQualifier();
                return qualifier == null || this.resolveQualifier(qualifier) != null;
            }
        };
    }

    private static void bindRef(@NotNull PsiClass targetClass, @NotNull GrReferenceElement ref2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiElement newRef = ref2.bindToElement((PsiElement)targetClass);
            JavaCodeStyleManager.getInstance((Project)targetClass.getProject()).shortenClassReferences(newRef);
        });
    }

    private static String getTemplateName(GrCreateClassKind createClassKind) {
        return switch (createClassKind) {
            default -> throw new IncompatibleClassChangeError();
            case GrCreateClassKind.TRAIT -> "Groovy Trait.groovy";
            case GrCreateClassKind.ENUM -> "Groovy Enum.groovy";
            case GrCreateClassKind.CLASS -> "Groovy Class.groovy";
            case GrCreateClassKind.INTERFACE -> "Groovy Interface.groovy";
            case GrCreateClassKind.ANNOTATION -> "Groovy Annotation.groovy";
            case GrCreateClassKind.RECORD -> "Groovy Record.groovy";
        };
    }
}

