/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToReferenceListFixKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0017\u0010\u001a\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToReferenceListFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "role", "Lcom/intellij/psi/PsiReferenceList$Role;", "addedName", "", "hostClassName", "(Lcom/intellij/psi/PsiReferenceList$Role;Ljava/lang/String;Ljava/lang/String;)V", "appendReferenceList", "", "dependentClass", "Lcom/intellij/psi/PsiClass;", "listToInsert", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrReferenceList;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generateNewList", "Lkotlin/Pair;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "getName", "getReplacedList", "Lcom/intellij/psi/PsiReferenceList;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToExtendsList;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToImplementsList;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToPermitsList;", "intellij.groovy.psi"})
public abstract class AddToReferenceListFix
implements LocalQuickFix {
    @NotNull
    private final PsiReferenceList.Role role;
    @NotNull
    private final String addedName;
    @NotNull
    private final String hostClassName;

    private AddToReferenceListFix(PsiReferenceList.Role role, String addedName, String hostClassName) {
        this.role = role;
        this.addedName = addedName;
        this.hostClassName = hostClassName;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.addedName, AddToReferenceListFixKt.access$getRepresentation(this.role), this.hostClassName};
        return GroovyBundle.message("intention.name.add.to.clause", objectArray);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Pair<PsiClass, GrReferenceList> pair = this.generateNewList(descriptor);
        if (pair == null) {
            return;
        }
        Pair<PsiClass, GrReferenceList> pair2 = pair;
        PsiClass dependentClass = (PsiClass)pair2.component1();
        GrReferenceList listToInsert = (GrReferenceList)pair2.component2();
        this.appendReferenceList(dependentClass, listToInsert);
    }

    private final Pair<PsiClass, GrReferenceList> generateNewList(ProblemDescriptor descriptor) {
        PsiElement psiElement;
        PsiClass referencedClass;
        block14: {
            block13: {
                PsiElement element;
                PsiElement psiElement2;
                block12: {
                    block11: {
                        psiElement2 = descriptor.getPsiElement();
                        if (psiElement2 == null) break block11;
                        PsiElement $this$asSafely$iv = psiElement2;
                        boolean $i$f$asSafely = false;
                        PsiElement psiElement3 = $this$asSafely$iv;
                        if (!(psiElement3 instanceof GrCodeReferenceElement)) {
                            psiElement3 = null;
                        }
                        if ((psiElement2 = (GrCodeReferenceElement)psiElement3) != null) break block12;
                    }
                    return null;
                }
                PsiElement $this$parentOfType_u24default$iv = element = psiElement2;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiClass.class, (boolean)true);
                if (psiClass == null) {
                    return null;
                }
                referencedClass = psiClass;
                psiElement = element.resolve();
                if (psiElement == null) break block13;
                PsiElement $this$asSafely$iv = psiElement;
                boolean $i$f$asSafely = false;
                PsiElement psiElement4 = $this$asSafely$iv;
                if (!(psiElement4 instanceof PsiClass)) {
                    psiElement4 = null;
                }
                if ((psiElement = (PsiClass)psiElement4) != null) break block14;
            }
            return null;
        }
        PsiElement dependentClass = psiElement;
        PsiReferenceList targetReferenceList = this.getReplacedList((PsiClass)dependentClass);
        String referencesRepresentation = targetReferenceList == null || targetReferenceList.getReferenceElements().length == 0 ? AddToReferenceListFixKt.access$getRepresentation(this.role) + " " + referencedClass.getQualifiedName() : targetReferenceList.getText() + ", " + referencedClass.getQualifiedName();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(referencedClass.getProject());
        GrTypeDefinition typeDefinition = factory.createTypeDefinition("class __Dummy " + referencesRepresentation + " {}");
        PsiReferenceList $this$asSafely$iv = this.getReplacedList(typeDefinition);
        boolean $i$f$asSafely = false;
        PsiReferenceList psiReferenceList = $this$asSafely$iv;
        if (!(psiReferenceList instanceof GrReferenceList)) {
            psiReferenceList = null;
        }
        GrReferenceList grReferenceList = (GrReferenceList)psiReferenceList;
        if (grReferenceList == null) {
            return null;
        }
        return TuplesKt.to((Object)dependentClass, (Object)grReferenceList);
    }

    private final PsiReferenceList getReplacedList(PsiClass dependentClass) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.role.ordinal()]) {
            case 1 -> dependentClass.getExtendsList();
            case 2 -> dependentClass.getImplementsList();
            case 3 -> dependentClass.getPermitsList();
            default -> throw new IllegalStateException("Unexpected".toString());
        };
    }

    private final void appendReferenceList(PsiClass dependentClass, GrReferenceList listToInsert) {
        PsiReferenceList listToReplace = this.getReplacedList(dependentClass);
        if (listToReplace == null) {
            dependentClass.addAfter((PsiElement)listToInsert, (PsiElement)dependentClass.getNameIdentifier());
        } else {
            listToReplace.replace((PsiElement)listToInsert);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Pair<PsiClass, GrReferenceList> pair = this.generateNewList(previewDescriptor);
        if (pair == null) {
            return IntentionPreviewInfo.EMPTY;
        }
        Pair<PsiClass, GrReferenceList> pair2 = pair;
        PsiClass dependentClass = (PsiClass)pair2.component1();
        GrReferenceList newList = (GrReferenceList)pair2.component2();
        PsiElement psiElement = dependentClass.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
        PsiClass copy = (PsiClass)psiElement;
        this.appendReferenceList(copy, newList);
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, dependentClass.getText(), copy.getText());
    }

    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("intention.family.name.add.class.to.clause", new Object[0]);
    }

    public /* synthetic */ AddToReferenceListFix(PsiReferenceList.Role role, String addedName, String hostClassName, DefaultConstructorMarker $constructor_marker) {
        this(role, addedName, hostClassName);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiReferenceList.Role.values().length];
            try {
                nArray[PsiReferenceList.Role.EXTENDS_LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiReferenceList.Role.IMPLEMENTS_LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiReferenceList.Role.PERMITS_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

