/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class CustomAnnotationChecker {
    public static final ExtensionPointName<CustomAnnotationChecker> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.customAnnotationChecker");

    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        return false;
    }

    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        return false;
    }

    @Nullable
    @InspectionMessage
    static String checkAnnotationApplicable(@NotNull GrAnnotation annotation, @Nullable PsiAnnotationOwner owner) {
        if (!(owner instanceof PsiElement)) {
            return null;
        }
        PsiElement ownerToUse = owner instanceof PsiModifierList ? ((PsiElement)owner).getParent() : (PsiElement)owner;
        PsiAnnotation.TargetType[] elementTypeFields = GrAnnotationImpl.getApplicableElementTypeFields(ownerToUse);
        if (elementTypeFields.length != 0 && !GrAnnotationImpl.isAnnotationApplicableTo(annotation, elementTypeFields)) {
            String annotationTargetText = JavaAnalysisBundle.message((String)("annotation.target." + elementTypeFields[0]), (Object[])new Object[0]);
            GrCodeReferenceElement ref2 = annotation.getClassReference();
            return JavaErrorBundle.message((String)"annotation.not.applicable", (Object[])new Object[]{ref2.getText(), annotationTargetText});
        }
        return null;
    }

    public static Pair<PsiElement, @InspectionMessage String> checkAnnotationArguments(@NotNull PsiClass annotation, GrAnnotationNameValuePair @NotNull [] attributes, boolean checkMissedAttributes) {
        PsiMethod[] methods;
        HashSet usedAttrs = new HashSet();
        if (((Pair.NonNull<PsiElement, String>)attributes).length > 0) {
            PsiElement identifier = attributes[0].getNameIdentifierGroovy();
            if (((Pair.NonNull<PsiElement, String>)attributes).length == 1 && identifier == null) {
                Pair.NonNull<PsiElement, String> r = CustomAnnotationChecker.checkAnnotationValue(annotation, attributes[0], "value", usedAttrs, attributes[0].getValue());
                if (r != null) {
                    return r;
                }
            } else {
                for (Pair.NonNull<PsiElement, String> attribute : attributes) {
                    String name = attribute.getName();
                    if (name == null) continue;
                    PsiElement toHighlight = attribute.getNameIdentifierGroovy();
                    assert (toHighlight != null);
                    Pair.NonNull<PsiElement, String> r = CustomAnnotationChecker.checkAnnotationValue(annotation, toHighlight, name, usedAttrs, attribute.getValue());
                    if (r == null) continue;
                    return r;
                }
            }
        }
        ArrayList<String> missedAttrs = new ArrayList<String>();
        for (PsiMethod method : methods = annotation.getMethods()) {
            String name = method.getName();
            if (usedAttrs.contains(name) || method instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)method).getDefaultValue() != null) continue;
            missedAttrs.add(name);
        }
        if (checkMissedAttributes && !missedAttrs.isEmpty()) {
            return Pair.create(null, (Object)GroovyBundle.message("missed.attributes", StringUtil.join(missedAttrs, (String)", ")));
        }
        return null;
    }

    private static Pair.NonNull<PsiElement, String> checkAnnotationValue(@NotNull PsiClass annotation, @NotNull PsiElement identifierToHighlight, @NotNull String name, @NotNull Set<? super String> usedAttrs, @Nullable GrAnnotationMemberValue value2) {
        if (!usedAttrs.add(name)) {
            return Pair.createNonNull((Object)identifierToHighlight, (Object)GroovyBundle.message("duplicate.attribute", new Object[0]));
        }
        PsiMethod[] methods = annotation.findMethodsByName(name, false);
        if (methods.length == 0) {
            return Pair.createNonNull((Object)identifierToHighlight, (Object)GroovyBundle.message("at.interface.0.does.not.contain.attribute", annotation.getQualifiedName(), name));
        }
        PsiMethod method = methods[0];
        PsiType ltype = method.getReturnType();
        if (ltype != null && value2 != null) {
            return CustomAnnotationChecker.checkAnnotationValueByType(value2, ltype, true);
        }
        return null;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    Pair.NonNull<PsiElement, @InspectionMessage String> checkAnnotationValueByType(@NotNull GrAnnotationMemberValue value2, @Nullable PsiType ltype, boolean skipArrays) {
        GlobalSearchScope resolveScope = value2.getResolveScope();
        PsiManager manager = value2.getManager();
        if (value2 instanceof GrExpression) {
            Object rtype = value2 instanceof GrFunctionalExpression ? PsiType.getJavaLangClass((PsiManager)manager, (GlobalSearchScope)resolveScope) : ((GrExpression)value2).getType();
            if (rtype != null && !CustomAnnotationChecker.isAnnoTypeAssignable(ltype, (PsiType)rtype, value2, skipArrays)) {
                return Pair.createNonNull((Object)value2, (Object)GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
            }
        } else if (value2 instanceof GrAnnotation) {
            PsiClassType rtype;
            PsiElement resolved = ((GrAnnotation)value2).getClassReference().resolve();
            if (resolved instanceof PsiClass && !CustomAnnotationChecker.isAnnoTypeAssignable(ltype, (PsiType)(rtype = JavaPsiFacade.getElementFactory((Project)value2.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY)), value2, skipArrays)) {
                return Pair.createNonNull((Object)value2, (Object)GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
            }
        } else if (value2 instanceof GrAnnotationArrayInitializer) {
            if (ltype instanceof PsiArrayType) {
                GrAnnotationMemberValue[] initializers;
                PsiType componentType = ((PsiArrayType)ltype).getComponentType();
                for (GrAnnotationMemberValue initializer : initializers = ((GrAnnotationArrayInitializer)value2).getInitializers()) {
                    Pair.NonNull<PsiElement, String> r = CustomAnnotationChecker.checkAnnotationValueByType(initializer, componentType, false);
                    if (r == null) continue;
                    return r;
                }
            } else {
                PsiType rtype = TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value2);
                if (!CustomAnnotationChecker.isAnnoTypeAssignable(ltype, rtype, value2, skipArrays)) {
                    return Pair.createNonNull((Object)value2, (Object)GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
                }
            }
        }
        return null;
    }

    private static boolean isAnnoTypeAssignable(@Nullable PsiType type2, @Nullable PsiType rtype, @NotNull GroovyPsiElement context, boolean skipArrays) {
        if (TypesUtil.isAssignableByMethodCallConversion(type2, rtype = TypesUtil.unboxPrimitiveTypeWrapper(rtype), context)) {
            return true;
        }
        if (!(type2 instanceof PsiArrayType) || !skipArrays) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        return CustomAnnotationChecker.isAnnoTypeAssignable(componentType, rtype, context, skipArrays);
    }
}

